<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:v="http://www.dforms.org/validation/1.0"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-e-date" match="*[contains(@display-as,'dforms-e-date')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="locale" select="'en'"/>
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:param name="ref" select="$view/d:ref"/>
		<xsl:element name="div">
			<xsl:attribute name="class">dforms-e-date</xsl:attribute>
			<xsl:element name="input">
				<xsl:attribute name="type">hidden</xsl:attribute>
				<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
				<xsl:attribute name="id"><xsl:value-of select="concat($id,'Model')"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="contains($name,'[0')"/>
					<xsl:when test="$model">
						<xsl:attribute name="value"><xsl:value-of select="$model" /></xsl:attribute>
					</xsl:when>
				</xsl:choose>
				<!-- add validation attributes -->
				<xsl:apply-templates select="$ref/@*" mode="add-v-attributes"/>
			</xsl:element>
			<xsl:element name="span">
				<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
				<xsl:if test="$id != ''">
					<xsl:attribute name="id"><xsl:value-of select="concat($id,'View')"/></xsl:attribute>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="contains($name,'[0')">
					</xsl:when>
					<xsl:when test="$model and $model !=''">
						<xsl:call-template name="format-date">
							<xsl:with-param name="date" select="$model"/>
							<xsl:with-param name="locale" select="'sk'"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&#160;</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
					<!-- add attributes do not remove 'if' - IE shit -->
				<xsl:if test="$attr">
					<xsl:apply-templates select="$attr" mode="add-attrs">
						<xsl:with-param name="namespace" select="$namespace" />
					</xsl:apply-templates>
				</xsl:if>
			</xsl:element>
			<xsl:call-template name="dforms-c-ctrl">
				<xsl:with-param name="title" select="'Nastaviť'"/>
				<xsl:with-param name="onclick">org.dforms.rk.DateEditor.display('<xsl:value-of select="$id"/>View','<xsl:value-of select="$id"/>Model','sk');return false;</xsl:with-param>
				<xsl:with-param name="id" select="$id"/>
				<xsl:with-param name="content" select="'&#x2026;'"/>
			</xsl:call-template>
			<xsl:call-template name="dforms-c-ctrl">
				<xsl:with-param name="title" select="'Zmazať'"/>
				<xsl:with-param name="onclick">org.dforms.rk.DateEditor.clear(this);</xsl:with-param>
				<xsl:with-param name="content" select="'c'"/>
			</xsl:call-template>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>