namespace("org.dforms.rk");
with(org.dforms.rk){
	org.dforms.rk.MultiSelect={};
	MultiSelect.selectAll=function(editorID){
		var editor=document.getElementById(editorID);
		var selects=editor.getElementsByTagName("select");
		var unselected=selects[0];
		var selected=selects[1];
		while(unselected.options.length>0){
			var option=unselected.options[unselected.length-1];
			unselected.options[unselected.length-1]=null;
			selected.options[selected.options.length]=option;
		}
	};
	MultiSelect.selectOne=function(editorID){
		var editor=document.getElementById(editorID);
		var selects=editor.getElementsByTagName("select");
		var unselected=selects[0];
		var selected=selects[1];
		var size=unselected.length;
		for(var i=size-1;i>=0;i--){
			var option=unselected.options[i];
			if(option.selected){
				unselected.options[i]=null;
				selected.options[selected.options.length]=option;
			}
		}
	};
	MultiSelect.unselectOne=function(editorID){
		var editor=document.getElementById(editorID);
		var selects=editor.getElementsByTagName("select");
		var unselected=selects[0];
		var selected=selects[1];
		var size=selected.length;
		for(var i=size-1;i>=0;i--){
			var option=selected.options[i];
			if(option.selected){
				selected.options[i]=null;
				unselected.options[unselected.options.length]=option;
			}
		}
	};
	MultiSelect.unselectAll=function(editorID){
		var editor=document.getElementById(editorID);
		var selects=editor.getElementsByTagName("select");
		var unselected=selects[0];
		var selected=selects[1];
		while(selected.options.length>0){
			var option=selected.options[selected.length-1];
			selected.options[selected.length-1]=null;
			unselected.options[unselected.options.length]=option;
		}
	};
	MultiSelect.selectSelected=function(form){
		try{
			var selects=form.getElementsByTagName("select");
			if(selects){
				for(var i=0;i<selects.length;i++){
					var sel=selects[i];
					var name=sel.getAttribute("name");
					if(name != null && name.indexOf("selected")==0){
						for(var j=0;j<sel.options.length;j++){
							sel.options[j].selected=true;
						}
					}
				}
			}
		}catch(e){
			alert(e);
		}
	};
}