<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:d="http://www.dforms.org/1.0"
	xmlns:v="http://www.dforms.org/validation/1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="dforms-e-radio" match="*[contains(name(),'radio-editor')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale"/>
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="default-name" />
		<xsl:param name="id"/>
		<xsl:param name="default-id" />
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:param name="ref" select="$view/d:ref"/>
		<xsl:element name="div">
			<xsl:attribute name="class">dforms-e-radio</xsl:attribute>
			<xsl:attribute name="v:validate">return org.dforms.rk.Radio.validate(this);</xsl:attribute>
			<xsl:if test="$id != ''">
				<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="$ref/@*" mode="add-v-attributes"/>
			<xsl:apply-templates select="$ref/d:values" mode="dforms-e-choice-path">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="locale" select="$locale" />
				<xsl:with-param name="view" select="$view" />
				<xsl:with-param name="name" select="$name" />
				<xsl:with-param name="id" select="$id" />
				<xsl:with-param name="default-name" select="$default-name" />
				<xsl:with-param name="default-id" select="$default-id" />
				<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
				<xsl:with-param name="disabled" select="$disabled"/>
				<xsl:with-param name="model" select="$model" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template name="dforms-e-radio-input" match="@name[.='dforms-e-radio']" mode="dforms-e-choice">
		<xsl:param name="namespace" />
		<xsl:param name="locale"/>
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="ignore-ns-prefix" />
		<xsl:param name="model" />
		<xsl:param name="value" />
		<xsl:param name="values" />
		<xsl:param name="position"/>
		<xsl:param name="disabled"/>
		<xsl:param name="view" select="$values/../.."/>
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:choose>
			<xsl:when test="normalize-space($view/d:meta[@name='orientation'])='horizontal'">
				<span>
					<xsl:call-template name="dforms-e-radio-impl">
						<xsl:with-param name="namespace" select="$namespace"/>
						<xsl:with-param name="name" select="$name"/>
						<xsl:with-param name="id" select="$id"/>
						<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
						<xsl:with-param name="model" select="$model"/>
						<xsl:with-param name="value" select="$value"/>
						<xsl:with-param name="values" select="$values"/>
						<xsl:with-param name="locale" select="$locale"/>
						<xsl:with-param name="position" select="$position"/>
						<xsl:with-param name="disabled" select="$disabled"/>
						<xsl:with-param name="view" select="$view"/>
						<xsl:with-param name="desc" select="$desc"/>
						<xsl:with-param name="attr" select="$attr"/>
					</xsl:call-template>
				</span>
			</xsl:when>
			<xsl:otherwise>
				<div>
					<xsl:call-template name="dforms-e-radio-impl">
						<xsl:with-param name="namespace" select="$namespace"/>
						<xsl:with-param name="name" select="$name"/>
						<xsl:with-param name="id" select="$id"/>
						<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
						<xsl:with-param name="model" select="$model"/>
						<xsl:with-param name="value" select="$value"/>
						<xsl:with-param name="values" select="$values"/>
						<xsl:with-param name="locale" select="$locale"/>
						<xsl:with-param name="position" select="$position"/>
						<xsl:with-param name="disabled" select="$disabled"/>
						<xsl:with-param name="view" select="$view"/>
						<xsl:with-param name="desc" select="$desc"/>
						<xsl:with-param name="attr" select="$attr"/>
					</xsl:call-template>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="dforms-e-radio-impl" match="xsl:template[@name='dforms-e-radio-impl']" mode="dforms-e-radio">
		<xsl:param name="namespace" />
		<xsl:param name="name" />
		<xsl:param name="locale"/>
		<xsl:param name="id" />
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="model" />
		<xsl:param name="value" />
		<xsl:param name="values" />
		<xsl:param name="position"/>
		<xsl:param name="disabled"/>
		<xsl:param name="view" select="$values/../.."/>
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:attribute name="class">item</xsl:attribute>
		<xsl:element name="input">
			<xsl:attribute name="type">radio</xsl:attribute>
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
			<xsl:if test="$id!=''">
				<xsl:attribute name="id"><xsl:value-of select="$id"/><xsl:value-of select="$position"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$disabled">
				<xsl:attribute name="disabled">disabled</xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="contains($name,'[0')">
					<xsl:attribute name="disabled">disabled</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:variable name="valueID">
				<xsl:call-template name="getChoiceValue">
					<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
					<xsl:with-param name="value" select="$value"/>
					<xsl:with-param name="path" select="$values/@value"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:attribute name="value"><xsl:value-of select="$valueID"/></xsl:attribute>
			<xsl:if test="$model and $model = $valueID">
				<xsl:attribute name="checked">checked</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
			<!-- add attributes do not remove 'if' - IE shit -->
			<xsl:if test="$attr">
				<xsl:apply-templates select="$attr" mode="add-attrs">
					<xsl:with-param name="namespace" select="$namespace" />
				</xsl:apply-templates>
			</xsl:if>
		</xsl:element>
		<xsl:element name="label">
			<xsl:attribute name="for"><xsl:value-of select="$id"/><xsl:value-of select="$position"/></xsl:attribute>
			<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
			<xsl:call-template name="getChoiceValue">
				<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
				<xsl:with-param name="value" select="$value"/>
				<xsl:with-param name="path" select="$values/@description"/>
			</xsl:call-template>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
