<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:v="http://www.dforms.org/validation/1.0"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-e-text" match="*[contains(name(),'text-editor')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="disabled"/>
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:param name="ref" select="$view/d:ref"/>
		<xsl:element name="input">
			<xsl:attribute name="type">text</xsl:attribute>
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
			<xsl:attribute name="class">dforms-e-text</xsl:attribute>
			<xsl:if test="$id != ''">
				<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
			<xsl:if test="boolean($ref/@v:maxLength)">
				<xsl:attribute name="maxlength"><xsl:value-of select="$ref/@v:maxLength"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="boolean($ref/@v:maxInclusive)">
				<xsl:attribute name="maxlength"><xsl:value-of select="string-length(string(number($ref/@v:maxInclusive)))"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="boolean($ref/@v:maxExclusive)">
				<xsl:attribute name="maxlength"><xsl:value-of select="string-length(string(number($ref/@v:maxExclusive)))"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$disabled">
				<xsl:attribute name="disabled">disabled</xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="contains($name,'[0')">
				</xsl:when>
				<xsl:when test="$model">
					<xsl:attribute name="value"><xsl:value-of select="$model" /></xsl:attribute>
				</xsl:when>
			</xsl:choose>
				<!-- add attributes do not remove 'if' - IE shit -->
			<xsl:if test="$attr">
				<xsl:apply-templates select="$attr" mode="add-attrs">
					<xsl:with-param name="namespace" select="$namespace" />
				</xsl:apply-templates>
			</xsl:if>
			<!-- add validation attributes -->
			<xsl:apply-templates select="$ref/@*" mode="add-v-attributes"/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>