<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:v="http://www.dforms.org/validation/1.0">
	<xsl:template name="dforms-e-user" match="*[@display-as = 'dforms-e-user']" mode="render">
		<xsl:param name="namespace"/>
		<xsl:param name="view"/>
		<xsl:param name="model"/>
		<xsl:param name="refs"/>
		<xsl:param name="position"/>
		<xsl:element name="table">
			<xsl:attribute name="id"><xsl:value-of select="$namespace"/><xsl:value-of select="$view/@name"/>E</xsl:attribute>
			<xsl:attribute name="style">
				width:auto;border-collapse: collapse;
				padding:0px;
				border:none;
				<xsl:value-of select="$view/meta[@name='style']/@value"/>
			</xsl:attribute>
			<tr>
				<td style="text-align:left;vertical-align:top;width:200px;padding:0px;">
					<xsl:element name="input">
						<xsl:attribute name="type">text</xsl:attribute>
						<xsl:attribute name="name"><xsl:value-of select="$view/@name"/></xsl:attribute>
						<xsl:attribute name="id"><xsl:value-of select="$namespace"/><xsl:value-of select="$view/@name"/></xsl:attribute>
						<xsl:attribute name="readonly">readonly</xsl:attribute>
						<xsl:attribute name="class">sdp-TextEditor</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$model/item[@name = $view/ref/@name]"/></xsl:attribute>
						<xsl:if test="$position=0">
							<xsl:attribute name="disabled">disabled</xsl:attribute>
						</xsl:if>
						<!-- Add attributes for validation module -->
							<xsl:for-each select="$view/ref/@*[namespace-uri()='http://www.dforms.org/validation/1.0']">
								<xsl:attribute name="v:{local-name()}"><xsl:value-of select="."/></xsl:attribute>
							</xsl:for-each>
					</xsl:element>
					<xsl:element name="input">
						<xsl:attribute name="type">hidden</xsl:attribute>
						<xsl:attribute name="name"><xsl:value-of select="$view/@name"/>DN</xsl:attribute>
						<xsl:attribute name="id"><xsl:value-of select="$namespace"/><xsl:value-of select="$view/@name"/>DN</xsl:attribute>
						<xsl:attribute name="readonly">readonly</xsl:attribute>
						<xsl:attribute name="class">sdp-TextEditor</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$model/item[@name = concat($view/ref/@name,'DN')]"/></xsl:attribute>
						<xsl:if test="$position=0">
							<xsl:attribute name="disabled">disabled</xsl:attribute>
						</xsl:if>
					</xsl:element>
					<td>
						<input type="button" class="button" id="{$view/@name}AddBtn" name="{$view/@name}AddBtn" value="Pridaj" 
							onclick="window.open('/pickers/rights/addright.jsp?checkboxes={$view/meta[@name='checkboxes']/@value}&amp;formName={$namespace}{$view/@name}&amp;theme={$view/meta[@name='theme']/@value}&amp;base={$view/meta[@name='base']/@value}&amp;usrFilter={$view/meta[@name='usrFilter']/@value}&amp;grpFilter={$view/meta[@name='grpFilter']/@value}&amp;orgFilter={$view/meta[@name='orgFilter']/@value}','{$view/@name}add_window','width=494, height=353, location=no, menubar=no, status=no, toolbar=no, scrollbars=no, resizable=no');"/>
					</td>
					<td>
						<input type="button" class="button" id="{$view/@name}RemoveBtn" name="{$view/@name}RemoveBtn" value="Odstráň" onclick="document.getElementById('{$namespace}{$view/@name}').value='';document.getElementById('{$namespace}{$view/@name}DN').value=''" />
					</td>
				</td>
			</tr>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>