<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:v="http://www.dforms.org/validation/1.0"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-p-combo" match="*[contains(name() ,'combo-panel')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="model" />
		<xsl:param name="view" select="."/>
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name" />
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:variable name="casepanel" select="$view/d:meta[@name='dforms-p-combo-casepanel']='true'"/>
		<xsl:element name="table">
			<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			<xsl:attribute name="class">
				<xsl:text>dforms-p-combo</xsl:text>
				<xsl:if test="$casepanel">
					<xsl:text>dforms-p-combo-case</xsl:text>
				</xsl:if>
			</xsl:attribute>
			<xsl:attribute name="v:onSuccess">org.dforms.rk.Combo.onSuccess(element, event);</xsl:attribute>
			<xsl:attribute name="v:onFailure">org.dforms.rk.Combo.onFailure(element, event);</xsl:attribute>
			<xsl:attribute name="v:onChildSuccess">org.dforms.rk.Combo.onChildSuccess(element, event);</xsl:attribute>
			<xsl:attribute name="v:onChildFailure">org.dforms.rk.Combo.onChildFailure(element, event);</xsl:attribute>
			<xsl:variable name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
			<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
			<xsl:variable name="content" select="*[contains(name(),'-panel') or contains(name(),'-editor') or contains(name(),'-viewer')]"/>
			<tbody>
				<xsl:if test="not($casepanel)">
					<tr>
						<td>
							<span class="dforms-p-combo-wrap">
								<select class="dforms-e-combo dforms-p-combo-combo"
										title="{$desc/@short-desc}"
										id="{$id}combo"
										name="{$name}"
										onchange="org.dforms.rk.Combo.onCombo('{$id}',this);">
									<xsl:for-each select="$content">
										<xsl:variable name="matches">
											<xsl:call-template name="dforms-p-combo-matches">
												<xsl:with-param name="model" select="$model"/>
												<xsl:with-param name="view" select="."/>
											</xsl:call-template>
										</xsl:variable>
										<xsl:element name="option">
											<xsl:variable name="descr" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
											<xsl:attribute name="title"><xsl:value-of select="$descr/@short-desc"/></xsl:attribute>
											<xsl:attribute name="value"><xsl:value-of select="position()"/></xsl:attribute>
											<xsl:if test="$matches = 'true'">
												<xsl:attribute name="selected">selected</xsl:attribute>
											</xsl:if>
											<xsl:value-of select="$descr/@display-name"/>
										</xsl:element>
									</xsl:for-each>
								</select>
							</span>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="dforms-p-combo-body">
						<table>
							<tbody>
								<xsl:apply-templates select="$content" mode="dforms-p-combo">
									<xsl:with-param name="namespace" select="$namespace" />
									<xsl:with-param name="locale" select="$locale" />
									<xsl:with-param name="model" select="$model" />
									<xsl:with-param name="id" select="$id" />
									<xsl:with-param name="generated-name" select="$generated-name" />
									<xsl:with-param name="generated-id" select="$generated-id" />
									<xsl:with-param name="default-name" select="$default-name"/>
									<xsl:with-param name="default-id" select="$default-id"/>
									<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
									<xsl:with-param name="disabled" select="$disabled"/>
									<xsl:with-param name="casepanel" select="$casepanel"/>
								</xsl:apply-templates>
							</tbody>
						</table>
					</td>
				</tr>
			</tbody>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*[contains(name(),'-panel') or contains(name(),'-editor') or contains(name(),'-viewer')]" mode="dforms-p-combo">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="model" />
		<xsl:param name="view" select="."/>
		<xsl:param name="id" />
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name"/>
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:param name="casepanel"/>
		<xsl:variable name="child-generated-name">
			<xsl:apply-templates select="$view" mode="name-generation">
				<xsl:with-param name="generated-name" select="$generated-name" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-generated-id">
			<xsl:apply-templates select="$view" mode="id-generation">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="generated-id" select="$generated-id" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-default-name">
			<xsl:choose>
				<xsl:when test="$view/@default-name"><xsl:value-of select="$view/@default-name" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$default-name" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-default-id">
			<xsl:choose>
				<xsl:when test="$view/@default-id"><xsl:value-of select="$view/@default-id" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$default-id" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-ignore-ns-prefix">
			<xsl:choose>
				<xsl:when test="$view/@ignore-ns-prefix"><xsl:value-of select="$view/@ignore-ns-prefix" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$ignore-ns-prefix" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-name">
			<xsl:apply-templates select="$view" mode="generate-name">
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="generated-name" select="$child-generated-name"/>
				<xsl:with-param name="default-name" select="$child-default-name" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-id">
			<xsl:apply-templates select="$view" mode="generate-id">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="generated-id" select="$child-generated-id"/>
				<xsl:with-param name="default-id" select="$child-default-id" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="matches">
			<xsl:call-template name="dforms-p-combo-matches">
				<xsl:with-param name="model" select="$model"/>
				<xsl:with-param name="view" select="."/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$casepanel">
				<xsl:if test="$matches = 'true'">
					<xsl:element name="tr">
						<xsl:attribute name="id"><xsl:value-of select="$id"/>combo<xsl:value-of select="position()"/></xsl:attribute>
						<td>
							<xsl:apply-templates select="." mode="data-binding">
								<xsl:with-param name="namespace" select="$namespace" />
								<xsl:with-param name="locale" select="$locale" />
								<xsl:with-param name="model" select="$model" />
								<xsl:with-param name="name" select="$child-name" />
								<xsl:with-param name="id" select="$child-id" />
								<xsl:with-param name="generated-name" select="$child-generated-name" />
								<xsl:with-param name="generated-id" select="$child-generated-id" />
								<xsl:with-param name="default-name" select="$child-default-name"/>
								<xsl:with-param name="default-id" select="$child-default-id"/>
								<xsl:with-param name="ignore-ns-prefix" select="$child-ignore-ns-prefix"/>
								<xsl:with-param name="disabled" select="$disabled or $matches = 'false'"/>
							</xsl:apply-templates>
						</td>
					</xsl:element>				
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="tr">
					<xsl:attribute name="id"><xsl:value-of select="$id"/>combo<xsl:value-of select="position()"/></xsl:attribute>
					<xsl:if test="$matches = 'false'">
						<xsl:attribute name="class">dforms-p-combo-hidden</xsl:attribute>
					</xsl:if>
					<td>
						<xsl:apply-templates select="." mode="data-binding">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$child-name" />
							<xsl:with-param name="id" select="$child-id" />
							<xsl:with-param name="generated-name" select="$child-generated-name" />
							<xsl:with-param name="generated-id" select="$child-generated-id" />
							<xsl:with-param name="default-name" select="$child-default-name"/>
							<xsl:with-param name="default-id" select="$child-default-id"/>
							<xsl:with-param name="ignore-ns-prefix" select="$child-ignore-ns-prefix"/>
							<xsl:with-param name="disabled" select="$disabled or $matches = 'false'"/>
						</xsl:apply-templates>
					</td>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="dforms-p-combo-matches" match="xsl:template[@name='dforms-p-combo-matches']" mode="data-binding">
		<xsl:param name="model" />
		<xsl:param name="view" />
		<xsl:variable name="path" select="string($view/d:meta[@name='dforms-p-combo-selector'])"/>
		<xsl:choose>
			<xsl:when test="$model">
				<xsl:choose>
					<xsl:when test="not(boolean($path)) and position()=1">true</xsl:when>
					<xsl:when test="contains($path, '&lt;=')"/>
					<xsl:when test="contains($path, '&gt;=')"/>
					<xsl:when test="contains($path, '=')"/>
					<xsl:when test="contains($path, 'not(')">
						<xsl:variable name="pred" select="substring-after($path, 'not(')"/>
						<xsl:variable name="element" select="substring-before($pred, ')')"/>
						<xsl:value-of select="not(boolean($model/*[local-name()=$element]))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="boolean($model/*[local-name()=$path])"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="position()=1">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>