namespace("org.dforms.rk");
depends("org.dforms.dom");
depends("org.dforms.validation");
with(org.dforms.rk){
	org.dforms.rk.Combo={};
	Combo.onSuccess= function(panel, event){
		with(org.dforms.validation){
			Event.fireEvent(new ChildSuccessEvent(event.context), event.context.parent);
		}
		Combo.getSelect(panel).style.color="";
	};
	Combo.onFailure= function(panel, event){
		var ev=event.events[0];
		var id=panel.getAttribute("id");
		var position=Combo.getPosition(ev.source);
		Combo.hideCombos(id);
		Combo.showCombo(document.getElementById(id + 'combo' + position));
		var select=Combo.getSelect(panel);
		select.selectedIndex=position - 1;
		select.style.color="red";
		with(org.dforms.validation){
			Event.fireEvent(new ChildFailureEvent(event.context, []), event.context.parent);
		}
	};
	Combo.onChildSuccess= function(panel, event){
		var id=event.source.id;
		var msgs=document.getElementById("msgs." + id);
		if(msgs){
			msgs.style.display="none";
			org.dforms.validation.Utils.clearMessages(msgs);
			var position=Combo.getPosition(event.source);
			Combo.unhighlightHead(Combo.getHead(panel, position));
		}
	};
	Combo.onChildFailure= function(panel, event){
		var id=event.source.id;
		var msgs=document.getElementById("msgs." + id);
		if(!msgs){
			var msgs=org.dforms.dom.Document.createElementNS("http://www.w3.org/1999/xhtml", "div");
			msgs.setAttribute("id", "msgs." + id);
			event.source.parentNode.insertBefore(msgs, event.source);
		}
		msgs.style.display="none";
		with(org.dforms.validation){
			Utils.clearMessages(msgs);
			Utils.showMessages(msgs, event.messages);
		}
		msgs.style.display="";
		var position=Combo.getPosition(event.source);
		Combo.highlightHead(Combo.getHead(panel, position));
	};
	Combo.getPosition= function(element){
		var childNodes=element.parentNode.parentNode.childNodes
		for( var i=0; i < childNodes.length; i++){
			if(childNodes[i].lastChild == element){
				return i + 1;
			}
		}
		return -1;
	};
	Combo.getHeads= function(panel){
		return Combo.getSelect(panel).options;
	};
	Combo.getSelect= function(panel){
		if(panel.tBodies.length > 0){
			panel=panel.tBodies[0];
		}
		var tr=panel.firstChild;
		var td=tr.firstChild;
		var span=td.firstChild;
		var select=span.firstChild;
		return select;
	};
	Combo.getHead= function(panel, position){
		return Combo.getHeads(panel)[position - 1];
	};
	Combo.highlightHead= function(head){
		head.style.color="red";
	};
	Combo.unhighlightHead= function(head){
		head.style.color="";
	};
	Combo.onCombo= function(id, select){
		var position=select.selectedIndex + 1;
		Combo.hideCombos(id);
		var pane=document.getElementById(id + 'combo' + position);
		Combo.showCombo(pane);
	};
	Combo.showCombo=function(pane){
		pane.style.display='block';
		Combo.setEnabled(pane, true);
	};
	Combo.hideCombo=function(pane){
		pane.style.display='none';
		Combo.setEnabled(pane, false);
	}
	Combo.hideCombos= function(id){
		var i=1;
		var tc=document.getElementById(id + 'combo' + i);
		while(tc){
			i++;
			Combo.hideCombo(tc);
			tc=document.getElementById(id + 'combo' + i);
		}
	};
	Combo.setEnabled= function(container, enabled){
		if(container.nodeName.toLowerCase() == 'input' || container.nodeName.toLowerCase() == 'textarea' || container.nodeName.toLowerCase == 'select'){
			if(enabled){
				container.removeAttribute("disabled");
			}else{
				container.setAttribute("disabled", "disabled");
			}
			return;
		}
		var childNodes=container.childNodes;
		for( var i=0; i < childNodes.length; i++){
			var node=childNodes[i];
			if(node.nodeType == 1){ // element node
				var id=node.getAttribute('id');
				var nclass=node.getAttribute('class');
				if(id == null || id.lastIndexOf("-template") == -1){
					if(nclass != null && (nclass.lastIndexOf("dforms-p-combo") > -1) && enabled){
						Combo.enableComboPanel(node)
					}else{
						Combo.setEnabled(node, enabled);
					}
				}
			}
		}
	};
	Combo.enableComboPanel= function(nnode){
		var id=nnode.getAttribute("id");
		var select=document.getElementById(id + "combo");
		select.removeAttribute("disabled");
		Combo.onCombo(id, select);
	};
}