<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-p-menu" match="*[contains(name() ,'menu-panel')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id" />
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name"/>
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:element name="div">
			<xsl:attribute name="class">dforms-p-menu</xsl:attribute>
			<xsl:apply-templates select="*[contains(name() ,'-action')]" mode="dforms-p-menu">
				<xsl:with-param name="namespace" select="$namespace"/>
				<xsl:with-param name="locale" select="$locale"/>
				<xsl:with-param name="model" select="$model"/>
				<xsl:with-param name="name" select="$name"/>
				<xsl:with-param name="id" select="$id"/>
				<xsl:with-param name="generated-name" select="$generated-name"/>
				<xsl:with-param name="generated-id" select="$generated-id"/>
				<xsl:with-param name="default-name" select="$default-name"/>
				<xsl:with-param name="default-id" select="$default-id"/>
				<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
				<xsl:with-param name="disabled" select="$disabled" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*[contains(name() ,'-action')]" mode="dforms-p-menu">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name"/>
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:variable name="child-generated-name">
			<xsl:apply-templates select="$view" mode="name-generation">
				<xsl:with-param name="generated-name" select="$generated-name" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-generated-id">
			<xsl:apply-templates select="$view" mode="id-generation">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="generated-id" select="$generated-id" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-default-name">
			<xsl:choose>
				<xsl:when test="$view/@default-name"><xsl:value-of select="$view/@default-name" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$default-name" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-default-id">
			<xsl:choose>
				<xsl:when test="$view/@default-id"><xsl:value-of select="$view/@default-id" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$default-id" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-ignore-ns-prefix">
			<xsl:choose>
				<xsl:when test="$view/@ignore-ns-prefix"><xsl:value-of select="$view/@ignore-ns-prefix" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$ignore-ns-prefix" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-name">
			<xsl:apply-templates select="$view" mode="generate-name">
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="generated-name" select="$child-generated-name"/>
				<xsl:with-param name="default-name" select="$child-default-name" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-id">
			<xsl:apply-templates select="$view" mode="generate-id">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="generated-id" select="$child-generated-id"/>
				<xsl:with-param name="default-id" select="$child-default-id" />
			</xsl:apply-templates>
		</xsl:variable>
		<span>
			<xsl:apply-templates select="." mode="data-binding">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="locale" select="$locale"/>
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="name" select="$child-name" />
				<xsl:with-param name="id" select="$child-id" />
				<xsl:with-param name="generated-name" select="$child-generated-name"/>
				<xsl:with-param name="generated-id" select="$child-generated-id"/>
				<xsl:with-param name="default-name" select="$child-default-name"/>
				<xsl:with-param name="default-id" select="$child-default-id"/>
				<xsl:with-param name="ignore-ns-prefix" select="$child-ignore-ns-prefix='true'"/>
				<xsl:with-param name="disabled" select="$disabled" />
			</xsl:apply-templates>
			<xsl:if test="position()!=last()">| </xsl:if>
		</span>
	</xsl:template>
</xsl:stylesheet>