<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:v="http://www.dforms.org/validation/1.0"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-p-tab" match="*[contains(name() ,'tab-panel')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="model" />
		<xsl:param name="view" select="."/>
		<xsl:param name="name"/>
		<xsl:param name="id" />
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name"/>
		<xsl:param name="default-id" />
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:element name="table">
			<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			<xsl:attribute name="class">dforms-p-tab</xsl:attribute>
			<xsl:attribute name="v:onSuccess">org.dforms.rk.Tab.onSuccess(element, event);</xsl:attribute>
			<xsl:attribute name="v:onFailure">org.dforms.rk.Tab.onFailure(element, event);</xsl:attribute>
			<xsl:attribute name="v:onChildSuccess">org.dforms.rk.Tab.onChildSuccess(element, event);</xsl:attribute>
			<xsl:attribute name="v:onChildFailure">org.dforms.rk.Tab.onChildFailure(element, event);</xsl:attribute>
			<xsl:variable name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
			<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
			<xsl:variable name="content" select="*[contains(name(),'-panel') or contains(name(),'-editor') or contains(name(),'-viewer')]"/>
				<tr>
					<xsl:for-each select="$content">
						<td class="sep">&#160;</td>
						<xsl:element name="td">
							<xsl:attribute name="onclick">org.dforms.rk.Tab.onTab('<xsl:value-of select="$id"/>', <xsl:value-of select="position()"/>, <xsl:value-of select="count($content)"/>);</xsl:attribute>
							<xsl:variable name="descr" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
							<xsl:attribute name="title"><xsl:value-of select="$descr/@short-desc"/></xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="$id"/>th<xsl:value-of select="position()"/></xsl:attribute>
							<xsl:choose>
								<xsl:when test="position()=1">
									<xsl:attribute name="class">dforms-p-tab-head-sel</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">dforms-p-tab-head</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:element name="a">
								<xsl:attribute name="href">#<xsl:value-of select="$descr/@display-name"/></xsl:attribute>
								<xsl:attribute name="class">dforms-p-tab-head-link</xsl:attribute>
								<xsl:attribute name="onclick">org.dforms.rk.Tab.onTab('<xsl:value-of select="$id"/>', <xsl:value-of select="position()"/>, <xsl:value-of select="count($content)"/>);</xsl:attribute>
								<xsl:value-of select="$descr/@display-name"/>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
					<td class="dforms-p-tab-last">&#160;</td>
				</tr>
				<tr>
					<td colspan="{count($content)*2+1}" class="dforms-p-tab-body">
						<xsl:apply-templates select="$content" mode="dforms-p-tab">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name"/>
							<xsl:with-param name="generated-id" select="$generated-id"/>
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
							<xsl:with-param name="disabled" select="$disabled"/>
						</xsl:apply-templates>
					</td>
				</tr>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*[contains(name(),'-panel') or contains(name(),'-editor') or contains(name(),'-viewer')]" mode="dforms-p-tab">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="model" />
		<xsl:param name="view" select="."/>
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name"/>
		<xsl:param name="default-id" />
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:variable name="child-generated-name">
			<xsl:apply-templates select="$view" mode="name-generation">
				<xsl:with-param name="generated-name" select="$generated-name" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-generated-id">
			<xsl:apply-templates select="$view" mode="id-generation">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="generated-id" select="$generated-id" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-default-name">
			<xsl:choose>
				<xsl:when test="$view/@default-name"><xsl:value-of select="$view/@default-name" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$default-name" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-default-id">
			<xsl:choose>
				<xsl:when test="$view/@default-id"><xsl:value-of select="$view/@default-id" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$default-id" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-ignore-ns-prefix">
			<xsl:choose>
				<xsl:when test="$view/@ignore-ns-prefix"><xsl:value-of select="$view/@ignore-ns-prefix" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$ignore-ns-prefix" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-name">
			<xsl:apply-templates select="$view" mode="generate-name">
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="generated-name" select="$child-generated-name"/>
				<xsl:with-param name="default-name" select="$child-default-name" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-id">
			<xsl:apply-templates select="$view" mode="generate-id">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="generated-id" select="$child-generated-id"/>
				<xsl:with-param name="default-id" select="$child-default-id" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:element name="div">
			<xsl:attribute name="id"><xsl:value-of select="$id"/>tab<xsl:value-of select="position()"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="position()=1">
					<xsl:attribute name="class">dforms-p-tab-sel</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="class">dforms-p-tab-hidden</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="." mode="data-binding">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="locale" select="$locale" />
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="name" select="$child-name" />
				<xsl:with-param name="id" select="$child-id" />
				<xsl:with-param name="generated-name" select="$child-generated-name"/>
				<xsl:with-param name="generated-id" select="$child-generated-id"/>
				<xsl:with-param name="default-name" select="$child-default-name" />
				<xsl:with-param name="default-id" select="$child-default-id" />
				<xsl:with-param name="ignore-ns-prefix" select="$child-ignore-ns-prefix='true'"/>
				<xsl:with-param name="disabled" select="$disabled" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>