namespace("org.dforms.rk");
depends("org.dforms.dom");
depends("org.dforms.validation");
with(org.dforms.rk){
	org.dforms.rk.Tab={};
	Tab.showTab=function(id, position){
		var th=document.getElementById(id+'th'+position);
		var tc=document.getElementById(id+'tab'+position);
		th.removeAttribute("onmouseover");
		th.removeAttribute("onmouseout");
		th.style.borderBottomStyle="none";
		th.style.backgroundColor="transparent";
		th.style.cursor="auto";
		th.className="dforms-p-tab-head-sel";
		tc.style.display='block';
	};
	Tab.hideTabs=function(id){
		var i=1;
		var th=document.getElementById(id+'th'+i);
		var tc=document.getElementById(id+'tab'+i);
		while(th){
			th.setAttribute("onmouseover","this.style.backgroundColor='rgb(201, 201, 218)'");
			th.setAttribute("onmouseout","this.style.backgroundColor='rgb(221, 221, 238)'");
			th.style.borderBottomStyle="solid";
			th.style.backgroundColor="rgb(221, 221, 238)";
			th.style.cursor="pointer";
			tc.style.display='none';
			i++;
			th=document.getElementById(id+'th'+i);
			tc=document.getElementById(id+'tab'+i);
		}
	};
	Tab.onTab=function(id, position){
		Tab.hideTabs(id);
		Tab.showTab(id, position);
	};
	Tab.onSuccess=function(panel, event){
		with(org.dforms.validation){
			Event.fireEvent(new ChildSuccessEvent(event.context),event.context.parent);
		}
	};
	Tab.onFailure=function(panel, event){
		var ev=event.events[0];
		var id=panel.getAttribute("id");
		var position=this.getPosition(ev.source);
		Tab.hideTabs(id);
		Tab.showTab(id, position);
		with(org.dforms.validation){
			Event.fireEvent(new ChildFailureEvent(event.context, []),event.context.parent);
		}
	};
	Tab.onChildSuccess=function(panel, event){
		var id=event.source.id;
		var msgs=document.getElementById("msgs."+id);
		if(msgs){
			msgs.style.display="none";
			org.dforms.validation.Utils.clearMessages(msgs);
			var position=Tab.getPosition(event.source);
			Tab.unhighlightHead(Tab.getHead(panel, position));
		}
	};
	Tab.onChildFailure=function(panel, event){
		var id=event.source.id;
		var msgs=document.getElementById("msgs."+id);
		if(!msgs){
			var msgs=org.dforms.dom.Document.createElementNS("http://www.w3.org/1999/xhtml","div");
			msgs.setAttribute("id","msgs."+id);
			event.source.parentNode.insertBefore(msgs,event.source);
		}
		msgs.style.display="none";
		with(org.dforms.validation){
			Utils.clearMessages(msgs);
			Utils.showMessages(msgs, event.messages);
		}
		msgs.style.display="";
		var position=Tab.getPosition(event.source);
		Tab.highlightHead(Tab.getHead(panel, position));
	};
	Tab.getPosition=function(element){
		var childNodes=element.parentNode.parentNode.childNodes
		for(var i=0;i<childNodes.length;i++){
			if(childNodes[i].lastChild == element){
				return i+1;
			}
		}
		return -1;
	};
	Tab.getHeads=function(panel){
		var heads=[];
		if(panel.tBodies.length > 0){
			panel=panel.tBodies[0];
		}
		var tr=panel.childNodes[0];
		var childNodes=tr.childNodes;
		for(var i=1;i<childNodes.length;i+=2){
			heads.push(childNodes[i]);
		}
		return heads;
	};
	Tab.getHead=function(panel, position){
		return Tab.getHeads(panel)[position-1];
	};
	Tab.highlightHead=function(head){
		head.style.color="red";
	};
	Tab.unhighlightHead=function(head){
		head.style.color="";
	};
}