<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:d="http://www.dforms.org/1.0"
	xmlns:v="http://www.dforms.org/validation/1.0"
	>
	<xsl:template name="dforms-p-coller" match="*[contains(@display-as ,'dforms-p-coller')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="position" select="1"/>
		<xsl:apply-templates select="d:item|d:panel|d:action" mode="dforms-p-coller">
			<xsl:with-param name="view" select="$view"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="d:panel" mode="dforms-p-coller">
		<xsl:param name="view" select="."/>
		<xsl:element name="colgroup">
			<xsl:apply-templates select="d:attr" mode="add-attrs"/>
			<xsl:apply-templates select="d:item|d:panel|d:action" mode="dforms-p-coller">
				<xsl:with-param name="view" select="$view"/>
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>	
	<xsl:template match="*" mode="dforms-p-coller">
		<xsl:param name="view" select="."/>
		<xsl:element name="col">
			<xsl:choose>
				<xsl:when test="d:ref/@v:type = 'string'">
					<xsl:attribute name="align">left</xsl:attribute>
				</xsl:when>
				<xsl:when test="d:ref/@v:type = 'number'">
					<xsl:attribute name="align">right</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:attribute name="width">0</xsl:attribute>
			<xsl:attribute name="style">color:blue;</xsl:attribute>
			<xsl:apply-templates select="d:attr" mode="add-attrs"/>
		</xsl:element>
	</xsl:template>	
</xsl:stylesheet>