<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:v="http://www.dforms.org/validation/1.0"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-p-header" match="*[contains(@display-as ,'dforms-p-header')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name" />
		<xsl:param name="default-id" />
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:param name="content" select="$view/@display-as"/>
		<xsl:variable name="maxDepth">
			<xsl:for-each select=".//d:item">
				<xsl:sort select="count(ancestor::*)" data-type="number"/>
				 <xsl:if test="position()=last()">
				   <xsl:copy-of select="count(ancestor::*)"/>
			  </xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="minDepth" select="count(ancestor::*)"/>
		<xsl:call-template name="dforms-p-headImp">
			<xsl:with-param name="namespace" select="$namespace"/>
			<xsl:with-param name="locale" select="$locale"/>
			<xsl:with-param name="view" select="$view"/>
			<xsl:with-param name="model" select="model"/>
			<xsl:with-param name="generated-name" select="$generated-name"/>
			<xsl:with-param name="generated-id" select="$generated-id"/>
			<xsl:with-param name="default-name" select="$default-name" />
			<xsl:with-param name="default-id" select="$default-id" />
			<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix" />
			<xsl:with-param name="disabled" select="$disabled" />
			<xsl:with-param name="depth" select="$minDepth + 1"/>
			<xsl:with-param name="minDepth" select="$minDepth"/>
			<xsl:with-param name="maxDepth" select="number($maxDepth)"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="dforms-p-headImp">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view"/>
		<xsl:param name="model"/>
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name" />
		<xsl:param name="default-id" />
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:param name="depth" />
		<xsl:param name="minDepth" />
		<xsl:param name="maxDepth" />
		<tr class="dforms-p-header-{($depth - $minDepth)}">
			<xsl:for-each select="$view//*[(local-name()='item' or local-name()='panel' or local-name()='action') and count(ancestor::*)=$depth]">
				<xsl:variable name="colspan" select="count(.//d:item|.//d:action)"/>
				<xsl:element name="th">
					<xsl:if test="$colspan > 1">
						<xsl:attribute name="colspan"><xsl:value-of select="$colspan"/></xsl:attribute>
					</xsl:if>
					<xsl:variable name="rowspan">
						<xsl:choose>
							<xsl:when test="$colspan>0">0</xsl:when>
							<xsl:otherwise><xsl:value-of  select="$maxDepth - $depth + 1"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:if test="$rowspan > 1">
						<xsl:attribute name="rowspan"><xsl:value-of select="$rowspan"/></xsl:attribute>
					</xsl:if>
					<xsl:attribute name="scope">
						<xsl:choose>
							<xsl:when test="$colspan>0">colgroup</xsl:when>
							<xsl:otherwise>col</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					<xsl:apply-templates select="d:desc/@short-desc" mode="add-title"/>
					<xsl:apply-templates select="d:attr" mode="add-attrs">
						<xsl:with-param name="namespace" select="$namespace"/>
					</xsl:apply-templates>
					<xsl:choose>
						<xsl:when test="@display-as">
							<xsl:variable name="child-generated-name">
								<xsl:apply-templates select="." mode="name-generation">
									<xsl:with-param name="generated-name" select="$generated-name" />
								</xsl:apply-templates>
							</xsl:variable>
							<xsl:variable name="child-generated-id">
								<xsl:apply-templates select="." mode="id-generation">
									<xsl:with-param name="namespace" select="$namespace" />
									<xsl:with-param name="generated-id" select="$generated-id" />
								</xsl:apply-templates>
							</xsl:variable>
							<xsl:variable name="child-default-name">
								<xsl:choose>
									<xsl:when test="@default-name"><xsl:value-of select="@default-name" /></xsl:when>
									<xsl:otherwise><xsl:value-of select="$default-name" /></xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:variable name="child-default-id">
								<xsl:choose>
									<xsl:when test="@default-id"><xsl:value-of select="@default-id" /></xsl:when>
									<xsl:otherwise><xsl:value-of select="$default-id" /></xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:variable name="child-ignore-ns-prefix">
								<xsl:choose>
									<xsl:when test="@ignore-ns-prefix"><xsl:value-of select="@ignore-ns-prefix" /></xsl:when>
									<xsl:otherwise><xsl:value-of select="$ignore-ns-prefix" /></xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:variable name="child-name">
								<xsl:apply-templates select="." mode="generate-name">
									<xsl:with-param name="model" select="$model" />
									<xsl:with-param name="generated-name" select="$child-generated-name"/>
									<xsl:with-param name="default-name" select="$child-default-name" />
								</xsl:apply-templates>
							</xsl:variable>
							<xsl:variable name="child-id">
								<xsl:apply-templates select="." mode="generate-id">
									<xsl:with-param name="namespace" select="$namespace" />
									<xsl:with-param name="model" select="$model" />
									<xsl:with-param name="generated-id" select="$child-generated-id"/>
									<xsl:with-param name="default-id" select="$child-default-id" />
								</xsl:apply-templates>
							</xsl:variable>
							<xsl:apply-templates select="." mode="data-binding">
								<xsl:with-param name="view" select="." />
								<xsl:with-param name="namespace" select="$namespace" />
								<xsl:with-param name="locale" select="$locale" />
								<xsl:with-param name="model" select="$model" />
								<xsl:with-param name="name" select="$child-name" />
								<xsl:with-param name="id" select="$child-id" />
								<xsl:with-param name="generated-name" select="$child-generated-name"/>
								<xsl:with-param name="generated-id" select="$child-generated-id"/>
								<xsl:with-param name="default-name" select="$child-default-name" />
								<xsl:with-param name="default-id" select="$child-default-id" />
								<xsl:with-param name="ignore-ns-prefix" select="$child-ignore-ns-prefix='true'" />
								<xsl:with-param name="disabled" select="$disabled" />
							</xsl:apply-templates>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="d:desc/@display-name"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:for-each>
			<xsl:variable name="cspan" select="count($view/../../d:panel[contains(@display-as, '-p-row')]/d:action)"/>
			<xsl:if test="$cspan>0">
				<th colspan="{$cspan}"></th>
			</xsl:if>
		</tr>
		<xsl:if test="$depth &lt; $maxDepth">
			<xsl:call-template name="dforms-p-headImp">
				<xsl:with-param name="namespace" select="$namespace"/>
				<xsl:with-param name="locale" select="$locale"/>
				<xsl:with-param name="view" select="$view"/>
				<xsl:with-param name="generated-name" select="$generated-name"/>
				<xsl:with-param name="generated-id" select="$generated-id"/>
				<xsl:with-param name="default-name" select="$default-name" />
				<xsl:with-param name="default-id" select="$default-id" />
				<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix" />
				<xsl:with-param name="disabled" select="$disabled" />
				<xsl:with-param name="depth" select="$depth + 1"/>
				<xsl:with-param name="minDepth" select="$minDepth"/>
				<xsl:with-param name="maxDepth" select="$maxDepth"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>	
</xsl:stylesheet>