<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-c-paging-backward" match="*[contains(@display-as ,'dforms-c-paging-backward')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="position" select="1"/>
		<xsl:param name="content" select="$view/@display-as"/>
		<xsl:message><xsl:value-of select="$model/../@page"/></xsl:message>
		<xsl:choose>
			<xsl:when test="$model/../@page = 0">
				<span title="{$view/d:desc/@short-desc}"><xsl:value-of select="$view/d:desc/@display-name"/></span>
			</xsl:when>
			<xsl:otherwise>
				<input type="submit" onclick="this.form.action='{$model}';" value="{$view/d:desc/@display-name}" title="{$view/d:desc/@short-desc}"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>