<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:d="http://www.dforms.org/1.0"
	xmlns:p="http://www.dforms.org/paging/1.0">
	<xsl:template name="dforms-c-page-num" match="*[contains(@display-as ,'dforms-c-page-num')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="position" select="1"/>
		<xsl:param name="content" select="$view/@display-as"/>
		<span class="num">
			<xsl:choose>
				<xsl:when test="$model/@count = 0">0</xsl:when>
				<xsl:otherwise>					
					<span>
					<xsl:choose>
						<xsl:when test="$model/@page+1 > $model/@count">
							<xsl:value-of select="$model/@	count"/>
						</xsl:when>
						<xsl:when test="0 > $model/@page">
							<xsl:value-of select="1"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$model/@page+1"/>		
						</xsl:otherwise>
					</xsl:choose>
					</span>
				</xsl:otherwise>
			</xsl:choose>
		</span>
	</xsl:template>
</xsl:stylesheet>