<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0"
	xmlns:p="http://www.dforms.org/marshalling/1.0">
	<d:panel display-as="dforms-p-xbox" ignore-ns-prefix="true">
		<d:attr name="class">dforms-c-paging</d:attr>
		<d:action display-as="dforms-c-paging-backward">
			<d:desc display-name="&lt;&lt;" short-desc="First Page"/>
			<d:ref select="first"/>
		</d:action>
		<d:action display-as="dforms-c-paging-backward">
			<d:desc display-name="&lt;" short-desc="Previous Page"/>
			<d:ref select="previous"/>
		</d:action>

		<d:action display-as="dforms-c-paging-pre">
			<d:meta name="dforms-p-adorn">false</d:meta>	
			<d:ref select="link"/>
		</d:action>
		<d:item display-as="dforms-c-page-num" >
			<d:meta name="dforms-p-adorn">false</d:meta>			
		</d:item>
		<d:action display-as="dforms-c-paging-post">
			<d:meta name="dforms-p-adorn">false</d:meta>	
			<d:ref select="link"/>
		</d:action>
		
		<d:action display-as="dforms-c-paging-forward">
			<d:desc display-name="&gt;" short-desc="Next Page"/>
			<d:ref select="next"/>
		</d:action>
		<d:action display-as="dforms-c-paging-forward">
			<d:desc display-name="&gt;&gt;" short-desc="Last Page"/>
			<d:ref select="last"/>
		</d:action>
	</d:panel>
	<xsl:template name="dforms-c-pagerList" match="*[contains(@display-as,'dforms-c-pagerList')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name" />
		<xsl:variable name="panel" select="document('Pager.xsl')/xsl:stylesheet/d:panel"/>
		<xsl:apply-templates select="$panel">
			<xsl:with-param name="namespace" select="$namespace" />
			<xsl:with-param name="model" select="$model" />
			<xsl:with-param name="name" select="$name" />
		</xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>