<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-c-paging-pre" match="*[contains(@display-as ,'dforms-c-paging-pre')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="position" select="1"/>
		<xsl:param name="content" select="$view/@display-as"/>

		<xsl:param name="count" select="$model/../@count"/>
		<xsl:param name="window">	
			<xsl:choose>
				<xsl:when test="$model/../@window > $count">
					<xsl:value-of select="$count"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$model/../@window"/>		
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<xsl:param name="actualPage">	
			<xsl:choose>
				<xsl:when test="$model/../@page+1 > $count">
					<xsl:value-of select="$count"/>
				</xsl:when>
				<xsl:when test="0 > $model/../@page">
					<xsl:value-of select="1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$model/../@page+1"/>		
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<xsl:param name="prefixLength" select="floor($window div 2)"/>


		
		<xsl:variable name="prefix">	
			<xsl:choose>
				<xsl:when test="$prefixLength > $count - $actualPage">
					<xsl:value-of select="floor(($window - 1) div 2) + $prefixLength + $actualPage - $count"/>
				</xsl:when>
				<xsl:when test="1  > $actualPage - $prefixLength ">
					<xsl:value-of select="$actualPage - 1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="floor(($window - 1) div 2)"/>		
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>		

		<xsl:call-template name="generatePrePagingList">
			<xsl:with-param name="i" select="1"/>
			<xsl:with-param name="actualPage" select="$actualPage"/>
			<xsl:with-param name="prefixLength" select="$prefix"/>
			<xsl:with-param name="count" select="$count"/>
			<xsl:with-param name="model" select="$model"/>
		</xsl:call-template>

	</xsl:template>

	<xsl:template name="generatePrePagingList">
		<xsl:param name="actualPage" />
		<xsl:param name="prefixLength" />
		<xsl:param name="model" />
		<xsl:param name="i" />
	
		<xsl:if test="$prefixLength >= $i">
			<xsl:call-template name="generatePrePagingList">
				<xsl:with-param name="i" select="$i+1"/>
				<xsl:with-param name="actualPage" select="$actualPage"/>
				<xsl:with-param name="prefixLength" select="$prefixLength"/>
				<xsl:with-param name="model" select="$model"/>
			</xsl:call-template>
			<input type="submit" onclick="this.form.action='{$model}?page={$actualPage - $i}';" value="{$actualPage - $i}" title="{$actualPage - $i}" />
		</xsl:if>

	</xsl:template>

</xsl:stylesheet>
