<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:v="http://www.dforms.org/validation/1.0"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-p-xbox" match="*[contains(name() ,'xbox-panel')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="model" />
		<xsl:param name="view" select="."/>
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name"/>
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:element name="table">
			<xsl:attribute name="class">dforms-p-xbox</xsl:attribute>
			<xsl:attribute name="v:onSuccess">org.dforms.rk.XBox.onSuccess(element, event);</xsl:attribute>
			<xsl:attribute name="v:onFailure">org.dforms.rk.XBox.onFailure(element, event);</xsl:attribute>
			<xsl:attribute name="v:onChildSuccess">org.dforms.rk.XBox.onChildSuccess(element, event);</xsl:attribute>
			<xsl:attribute name="v:onChildFailure">org.dforms.rk.XBox.onChildFailure(element, event);</xsl:attribute>
			<xsl:if test="$id!=''">
				<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			</xsl:if>
			<xsl:variable name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
			<xsl:message>xbox $desc/@short-desc:<xsl:value-of select="$desc/@short-desc"/> locale:<xsl:value-of select="$locale"/></xsl:message>
			<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
			<xsl:if test="d:attr">
				<xsl:apply-templates select="d:attr" mode="add-attrs">
					<xsl:with-param name="namespace" select="$namespace" />
				</xsl:apply-templates>
			</xsl:if>
			<tr>
				<xsl:apply-templates select="*[contains(name(),'-editor') or contains(name(),'-viewer') or contains(name(),'-panel') or contains(name(),'-action')]" mode="dforms-p-xbox">
					<xsl:with-param name="namespace" select="$namespace"/>
					<xsl:with-param name="locale" select="$locale"/>
					<xsl:with-param name="model" select="$model"/>
					<xsl:with-param name="generated-name" select="$generated-name"/>
					<xsl:with-param name="generated-id" select="$generated-id"/>
					<xsl:with-param name="default-name" select="$default-name" />
					<xsl:with-param name="default-id" select="$default-id" />
					<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
					<xsl:with-param name="disabled" select="$disabled"/>
					<xsl:with-param name="default-adorn" select="not(d:meta[@name='dforms-p-default-adorn'] = 'false')" />
				</xsl:apply-templates>
			</tr>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="dforms-p-xbox">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name"/>
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:param name="default-adorn"/>
		<xsl:variable name="child-generated-name">
			<xsl:apply-templates select="$view" mode="name-generation">
				<xsl:with-param name="generated-name" select="$generated-name" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-generated-id">
			<xsl:apply-templates select="$view" mode="id-generation">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="generated-id" select="$generated-id" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-default-name">
			<xsl:choose>
				<xsl:when test="$view/@default-name"><xsl:value-of select="$view/@default-name" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$default-name" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-default-id">
			<xsl:choose>
				<xsl:when test="$view/@default-id"><xsl:value-of select="$view/@default-id" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$default-id" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-ignore-ns-prefix">
			<xsl:choose>
				<xsl:when test="$view/@ignore-ns-prefix"><xsl:value-of select="$view/@ignore-ns-prefix" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$ignore-ns-prefix" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="child-name">
			<xsl:apply-templates select="$view" mode="generate-name">
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="generated-name" select="$child-generated-name"/>
				<xsl:with-param name="default-name" select="$child-default-name" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="child-id">
			<xsl:apply-templates select="$view" mode="generate-id">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="generated-id" select="$child-generated-id"/>
				<xsl:with-param name="default-id" select="$child-default-id" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:variable name="adorn" select="normalize-space($view/d:meta[@name='dforms-p-adorn'])"/>
		<xsl:variable name="should-adorn" select="$adorn='true' or ($default-adorn and $adorn!='false' and not(contains(name($view),'-action')))"/>
		<xsl:variable name="is-gap" select="local-name()='item' and not(@display-as)"/>
		<xsl:if test="$should-adorn and not($is-gap)">
			<td class="label">
				<xsl:if test="$desc/@icon">
					<img src="{$desc/@icon}" alt="{$desc/@display-name}" title="{$desc/@short-desc}"/>
				</xsl:if>
				<xsl:call-template name="dforms-v-label">
					<xsl:with-param name="namespace" select="$namespace"/>
					<xsl:with-param name="locale" select="$locale"/>
					<xsl:with-param name="view" select="$view"/>
					<xsl:with-param name="model" select="$desc/@display-name"/>
					<xsl:with-param name="name" select="$child-name"/>
					<xsl:with-param name="id" select="$child-id"/>
				</xsl:call-template>
			</td>
		</xsl:if>
		<xsl:element name="td">
			<xsl:if test="not($should-adorn) or $is-gap">
				<xsl:attribute name="colspan">2</xsl:attribute>
			</xsl:if>
			<xsl:if test="$is-gap">
				<xsl:text>&#160;</xsl:text>
			</xsl:if>
			<xsl:apply-templates select="." mode="data-binding">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="locale" select="$locale"/>
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="name" select="$child-name" />
				<xsl:with-param name="id" select="$child-id" />
				<xsl:with-param name="generated-name" select="$child-generated-name"/>
				<xsl:with-param name="generated-id" select="$child-generated-id"/>
				<xsl:with-param name="default-name" select="$child-default-name"/>
				<xsl:with-param name="default-id" select="$child-default-id"/>
				<xsl:with-param name="ignore-ns-prefix" select="$child-ignore-ns-prefix='true'"/>
				<xsl:with-param name="disabled" select="$disabled"/>
			</xsl:apply-templates>
			<xsl:if test="$should-adorn and string($desc)">
				<xsl:call-template name="dforms-c-contextHelp">
					<xsl:with-param name="namespace" select="$namespace"/>
					<xsl:with-param name="locale" select="$locale"/>
					<xsl:with-param name="view" select="."/>
					<xsl:with-param name="name" select="$child-name"/>
					<xsl:with-param name="id" select="$child-id"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>