namespace("org.dforms.rk");
depends("org.dforms.dom");
depends("org.dforms.validation");
with(org.dforms.rk){
	org.dforms.rk.XBox={};
	XBox.onChildFailure=function(panel, event, cols){
		var id=event.source.id;
		var row=XBox.getPosition(panel, event.source);
		var msgs=document.getElementById("msgs."+id);
		if(!msgs){
			var tr=org.dforms.dom.Document.createElementNS("http://www.w3.org/1999/xhtml", "tr");
			var span=event.source.parentNode.parentNode.childNodes.length;
			if(event.source.parentNode.parentNode.childNodes[0].childNodes[0].nodeName=="label"){
				tr.appendChild(org.dforms.dom.Document.createElementNS("http://www.w3.org/1999/xhtml", "td"));
				span--;
			}
			msgs=org.dforms.dom.Document.createElementNS("http://www.w3.org/1999/xhtml", "td");
			msgs.setAttribute("colspan",span);
			msgs.setAttribute("id","msgs."+id);
			tr.appendChild(msgs);
			if(panel.tBodies.length > 0){
				panel=panel.tBodies[0];
			}
			panel.insertBefore(tr,event.source.parentNode.parentNode);
		}
		msgs.parentNode.style.display="none";
		with(org.dforms.validation){
			Utils.clearMessages(msgs);
			Utils.addLabelTextTo(event);
			Utils.showMessages(msgs, event.messages);
			msgs.parentNode.style.display="";
			Utils.highlightLabel(id);
		}
	};
	XBox.onChildSuccess=function(panel, event, cols){
		var id=event.source.id;
		var msgs=document.getElementById("msgs."+id);
		if(msgs){
			msgs.parentNode.style.display="none";
			with(org.dforms.validation){
				Utils.clearMessages(msgs);
				Utils.unhighlightLabel(id);
			}
		}
	};
	XBox.onSuccess=function(panel, event, cols){
		with(org.dforms.validation){
			Event.fireEvent(new ChildSuccessEvent(event.context),event.context.parent);
		}
	};
	XBox.onFailure=function(panel, event, cols){
		with(org.dforms.validation){
			Event.fireEvent(new ChildFailureEvent(event.context, []),event.context.parent);
		}
	};
	XBox.getRows=function(panel){
		var rows=[];
		var childNodes=panel.childNodes;
		for(var i=0;i<childNodes.length;i++){
			var node=childNodes[i];
			if(!node.id || node.id.indexOf("msgs.")!=0){
				rows.push(node);
			}
		}
		return rows;
	};
	XBox.getPosition=function(panel, element){
		var rows=XBox.getRows(panel);
		for(var i=0;i<rows.length;i++){
			if(org.dforms.dom.Element.isDescendantOrSelf(rows[i], element)){
				return i+1;
			}
		}
		return -1;
	};
}