namespace("org.dforms.rk");
depends("org.dforms.dom");
depends("org.dforms.validation");
with(org.dforms.rk){
	org.dforms.rk.YBox={};
	YBox.onChildFailure=function(panel, event){
		var id=event.source.id;
		var msgs=document.getElementById("msgs."+id);
		if(!msgs){
			var row=org.dforms.dom.Element.getParentByTagName(event.source, "tr");
			var tr=org.dforms.dom.Document.createElementNS("http://www.w3.org/1999/xhtml", "tr");
			if(event.source.parentNode.previousSibling){
				tr.appendChild(org.dforms.dom.Document.createElementNS("http://www.w3.org/1999/xhtml", "td"));
			}
			msgs=org.dforms.dom.Document.createElementNS("http://www.w3.org/1999/xhtml", "td");
			msgs.setAttribute("id", "msgs."+id);
			tr.appendChild(msgs);
			if(panel.tBodies && panel.tBodies.length > 0){
				panel=panel.tBodies[0];
			}
			panel.insertBefore(tr, row);
		}
		msgs.parentNode.style.display="none";
		with(org.dforms.validation){
			Utils.clearMessages(msgs);
			Utils.showMessages(msgs, event.messages);
			msgs.parentNode.style.display="";
			Utils.highlightLabel(id);
		}
	};
	YBox.onChildSuccess=function(panel, event){
		var id=event.source.id;
		var msgs=document.getElementById("msgs."+id);
		if(msgs){
			msgs.parentNode.style.display="none";
			with(org.dforms.validation){
				Utils.clearMessages(msgs);
				Utils.unhighlightLabel(id);
			}
		}
	};
	YBox.onSuccess=function(panel, event){
		with(org.dforms.validation){
			Event.fireEvent(new ChildSuccessEvent(event.context),event.context.parent);
		}
	};
	YBox.onFailure=function(panel, event){
		with(org.dforms.validation){
			Event.fireEvent(new ChildFailureEvent(event.context, []),event.context.parent);
		}
	};
}