<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0"
	xmlns:v="http://www.dforms.org/validation/1.0">
	<xsl:import href="utils/name-generation.xsl" />
	<xsl:import href="utils/id-generation.xsl" />
	<xsl:import href="utils/data-binding.xsl" />
	<xsl:import href="utils/data-binding-ns.xsl" />
 	<xsl:import href="utils/choice.xsl" />
	<xsl:import href="utils/choice-ns.xsl" />
	<xsl:import href="utils/internet-date-format.xsl" />
	<xsl:template name="replace-string">
		<xsl:param name="text" />
		<xsl:param name="replace" />
		<xsl:param name="with" />
		<xsl:choose>
			<xsl:when test="contains($text,$replace)">
				<xsl:value-of select="substring-before($text,$replace)" />
				<xsl:value-of select="$with" />
				<xsl:call-template name="replace-string">
					<xsl:with-param name="text" select="substring-after($text,$replace)" />
					<xsl:with-param name="replace" select="$replace" />
					<xsl:with-param name="with" select="$with" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*" mode="data-binding">
		<xsl:param name="namespace" select="/d:form/@namespace"/>
		<xsl:param name="locale" select="/d:form/@locale"/>
		<xsl:param name="view" select="." />
		<xsl:param name="model" select="/d:form/d:data"/>
		<xsl:param name="generated-name">
			<xsl:apply-templates select="$view" mode="name-generation">
				<xsl:with-param name="generated-name" select="''" />
			</xsl:apply-templates>
		</xsl:param>
		<xsl:param name="generated-id">
			<xsl:apply-templates select="$view" mode="id-generation">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="generated-id" select="$namespace" />
			</xsl:apply-templates>
		</xsl:param>
		<xsl:param name="default-name" select="'{generate-name()}'" />
		<xsl:param name="default-id" select="'{generate-id()}'" />
		<xsl:param name="name">
			<xsl:apply-templates select="$view" mode="generate-name">
				<xsl:with-param name="model" select="$namespace/../d:data" />
				<xsl:with-param name="generated-name" select="$generated-name"/>
				<xsl:with-param name="default-name" select="$default-name" />
			</xsl:apply-templates>
		</xsl:param>
		<xsl:param name="id">
			<xsl:apply-templates select="$view" mode="generate-id">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="model" select="$model" />
				<xsl:with-param name="default-id" select="$default-id" />
				<xsl:with-param name="generated-id">
					<xsl:apply-templates select="$view" mode="id-generation">
						<xsl:with-param name="namespace" select="$namespace" />
						<xsl:with-param name="generated-id" select="$generated-id" />
						<xsl:with-param name="default-id" select="$default-id" />
					</xsl:apply-templates>
				</xsl:with-param>
			</xsl:apply-templates>
		</xsl:param>
		<xsl:param name="ignore-ns-prefix" select="not(boolean(@ignore-ns-prefix)) or @ignore-ns-prefix!='false'"/>
		<xsl:param name="disabled" select="false()" />
		<xsl:param name="params" />
		<xsl:message>ignore-ns-prefix=<xsl:value-of select="$ignore-ns-prefix"/></xsl:message>
		<xsl:choose>
			<xsl:when test="$ignore-ns-prefix">
				<xsl:apply-templates select="$view" mode="data-bindings">
					<xsl:with-param name="namespace" select="$namespace" />
					<xsl:with-param name="locale" select="$locale" />
					<xsl:with-param name="model" select="$model" />
					<xsl:with-param name="view" select="$view" />
					<xsl:with-param name="name" select="$name" />
					<xsl:with-param name="id" select="$id" />
					<xsl:with-param name="generated-name" select="$generated-name" />
					<xsl:with-param name="generated-id" select="$generated-id" />
					<xsl:with-param name="default-name" select="$default-name" />
					<xsl:with-param name="default-id" select="$default-id" />
					<xsl:with-param name="disabled" select="$disabled" />
					<xsl:with-param name="params" select="$params" />
					<xsl:with-param name="refs" select="$view/d:ref" />
					<xsl:with-param name="models" select="/.." />
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="$view" mode="data-bindings-ns">
					<xsl:with-param name="namespace" select="$namespace" />
					<xsl:with-param name="locale" select="$locale" />
					<xsl:with-param name="model" select="$model" />
					<xsl:with-param name="view" select="$view" />
					<xsl:with-param name="name" select="$name" />
					<xsl:with-param name="id" select="$id" />
					<xsl:with-param name="generated-name" select="$generated-name" />
					<xsl:with-param name="generated-id" select="$generated-id" />
					<xsl:with-param name="default-name" select="$default-name" />
					<xsl:with-param name="default-id" select="$default-id" />
					<xsl:with-param name="disabled" select="$disabled" />
					<xsl:with-param name="params" select="$params" />
					<xsl:with-param name="refs" select="$view/d:ref" />
					<xsl:with-param name="models" select="/.." />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	<xsl:template match="d:attr" mode="add-attrs">
		<xsl:param name="namespace" />
		<xsl:attribute name="{@name}">
			<xsl:choose>
				<xsl:when test="starts-with(@name,'on')">
					<xsl:call-template name="replace-string">
						<xsl:with-param name="text" select="." />
						<xsl:with-param name="replace" select="'##namespace'" />
						<xsl:with-param name="with" select="$namespace" />
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="." />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
	</xsl:template>
	<xsl:template match="@*" mode="add-v-attributes">
		<xsl:if test="namespace-uri()='http://www.dforms.org/validation/1.0'">
			<xsl:attribute name="v:{local-name()}" namespace="http://www.dforms.org/validation/1.0"><xsl:value-of select="." /></xsl:attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template match="@*" mode="add-title">
		<xsl:attribute name="title"><xsl:value-of select="." /></xsl:attribute>
	</xsl:template>
</xsl:stylesheet>