<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template match="*" mode="dforms-e-choice-path">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="model" />
		<xsl:param name="view" />
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="ignore-ns-prefix" />
		<xsl:param name="disabled" />
		<xsl:param name="path" select="@select"/>
		<xsl:choose>
			<xsl:when test="starts-with($path, '/')">
				<xsl:apply-templates select="." mode="dforms-e-choice-node">
					<xsl:with-param name="namespace" select="$namespace" />
					<xsl:with-param name="locale" select="$locale" />
					<xsl:with-param name="view" select="$view" />
					<xsl:with-param name="name" select="$name" />
					<xsl:with-param name="id" select="$id" />
					<xsl:with-param name="disabled" select="$disabled" />
					<xsl:with-param name="model" select="$model"/>
					<xsl:with-param name="value" select="$namespace/../d:data"/>
					<xsl:with-param name="path" select="substring($path,2)" />
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="$ignore-ns-prefix">
				<xsl:apply-templates select="." mode="dforms-e-choice-node">
					<xsl:with-param name="namespace" select="$namespace" />
					<xsl:with-param name="locale" select="$locale" />
					<xsl:with-param name="view" select="$view" />
					<xsl:with-param name="name" select="$name" />
					<xsl:with-param name="id" select="$id" />
					<xsl:with-param name="disabled" select="$disabled" />
					<xsl:with-param name="model" select="$model"/>
					<xsl:with-param name="value" select="$model/.."/>
					<xsl:with-param name="path" select="$path" />
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="." mode="dforms-e-choice-node-ns">
					<xsl:with-param name="namespace" select="$namespace" />
					<xsl:with-param name="locale" select="$locale" />
					<xsl:with-param name="view" select="$view" />
					<xsl:with-param name="name" select="$name" />
					<xsl:with-param name="id" select="$id" />
					<xsl:with-param name="disabled" select="$disabled" />
					<xsl:with-param name="model" select="$model"/>
					<xsl:with-param name="value" select="$model/.."/>
					<xsl:with-param name="path" select="$path" />
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*" mode="dforms-e-choice-node">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" />
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="disabled" />
		<xsl:param name="model" />
		<xsl:param name="value" />
		<xsl:param name="values" select="."/>
		<xsl:param name="path"/>
		<xsl:variable name="after" select="substring-after($path, '/')"/>
		<xsl:choose>
			<xsl:when test="$after">
				<xsl:variable name="before" select="substring-before($path, '/')"/>
				<xsl:apply-templates select="." mode="dforms-e-choice-node">
					<xsl:with-param name="namespace" select="$namespace" />
					<xsl:with-param name="locale" select="$locale" />
					<xsl:with-param name="view" select="$view" />
					<xsl:with-param name="name" select="$name" />
					<xsl:with-param name="id" select="$id" />
					<xsl:with-param name="disabled" select="$disabled" />
					<xsl:with-param name="model" select="$model" />
					<xsl:with-param name="value" select="$value/*[local-name()=$before]"/>
					<xsl:with-param name="path" select="$after"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>

				<xsl:for-each select="$value/*[local-name()=$path]">
					<xsl:choose>
						<xsl:when test="contains(name($view), 'combo-editor')">
							<xsl:call-template name="dforms-e-combo-option">
								<xsl:with-param name="namespace" select="$namespace" />
								<xsl:with-param name="locale" select="$locale" />
								<xsl:with-param name="view" select="$view" />
								<xsl:with-param name="name" select="$name" />
								<xsl:with-param name="id" select="$id" />
								<xsl:with-param name="ignore-ns-prefix" select="true()" />
								<xsl:with-param name="disabled" select="$disabled" />
								<xsl:with-param name="model" select="$model" />
								<xsl:with-param name="value" select="." />
								<xsl:with-param name="values" select="$values" />
								<xsl:with-param name="position" select="position()" />
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="contains(name($view), 'radio-editor')">
							<xsl:call-template name="dforms-e-radio-input">
								<xsl:with-param name="namespace" select="$namespace" />
								<xsl:with-param name="locale" select="$locale" />
								<xsl:with-param name="view" select="$view" />
								<xsl:with-param name="name" select="$name" />
								<xsl:with-param name="id" select="$id" />
								<xsl:with-param name="ignore-ns-prefix" select="true()" />
								<xsl:with-param name="disabled" select="$disabled" />
								<xsl:with-param name="model" select="$model" />
								<xsl:with-param name="value" select="." />
								<xsl:with-param name="values" select="$values" />
								<xsl:with-param name="position" select="position()" />
							</xsl:call-template>
						</xsl:when>		
						
						<xsl:when test="contains(name($view), 'choice-viewer')">
							<xsl:call-template name="dforms-v-choice-option">
								<xsl:with-param name="namespace" select="$namespace" />
								<xsl:with-param name="locale" select="$locale" />
								<xsl:with-param name="view" select="$view" />
								<xsl:with-param name="name" select="$name" />
								<xsl:with-param name="id" select="$id" />
								<xsl:with-param name="ignore-ns-prefix" select="true()" />
								<xsl:with-param name="disabled" select="$disabled" />
								<xsl:with-param name="model" select="$model" />
								<xsl:with-param name="value" select="." />
								<xsl:with-param name="values" select="$values" />
								<xsl:with-param name="position" select="position()" />
							</xsl:call-template>
						</xsl:when>						
					</xsl:choose>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getChoiceValue">
		<xsl:param name="ignore-ns-prefix" />
		<xsl:param name="value" />
		<xsl:param name="path" />
			<xsl:choose>
				<xsl:when test="boolean($ignore-ns-prefix)">
					<xsl:call-template name="selectSingleNode">
						<xsl:with-param name="ctx" select="/..|$value"/>
						<xsl:with-param name="path" select="$path"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="selectSingleNodeNS">
						<xsl:with-param name="ctx" select="/..|$value"/>
						<xsl:with-param name="path" select="$path"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
</xsl:template>
</xsl:stylesheet>