<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="selectPathsAndApplyNS" match="*" mode="data-bindings-ns">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="generated-name" />
		<xsl:param name="generated-id" />
		<xsl:param name="default-name" />
		<xsl:param name="default-id" />
		<xsl:param name="disabled" />
		<xsl:param name="params" />
		<xsl:param name="refs" />
		<xsl:param name="models" />
		<xsl:choose>
			<xsl:when test="not($view/d:ref)">
				<xsl:apply-templates select="$view" mode="x-render">
					<xsl:with-param name="namespace" select="$namespace" />
					<xsl:with-param name="locale" select="$locale" />
					<xsl:with-param name="model" select="$model" />
					<xsl:with-param name="name" select="$name" />
					<xsl:with-param name="id" select="$id" />
					<xsl:with-param name="generated-name" select="$generated-name" />
					<xsl:with-param name="generated-id" select="$generated-id" />
					<xsl:with-param name="default-name" select="$default-name" />
					<xsl:with-param name="default-id" select="$default-id" />
					<xsl:with-param name="ignore-ns-prefix" select="false()" />
					<xsl:with-param name="disabled" select="$disabled" />
					<xsl:with-param name="params" select="$params" />
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="count($refs)=0">
				<xsl:apply-templates select="$view" mode="x-render">
					<xsl:with-param name="namespace" select="$namespace" />
					<xsl:with-param name="locale" select="$locale" />
					<xsl:with-param name="model" select="$models" />
					<xsl:with-param name="name" select="$name" />
					<xsl:with-param name="id" select="$id" />
					<xsl:with-param name="generated-name" select="$generated-name" />
					<xsl:with-param name="generated-id" select="$generated-id" />
					<xsl:with-param name="default-name" select="$default-name" />
					<xsl:with-param name="default-id" select="$default-id" />
					<xsl:with-param name="ignore-ns-prefix" select="false()" />
					<xsl:with-param name="disabled" select="$disabled" />
					<xsl:with-param name="params" select="$params" />
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="path" select="$refs[1]/@select" />
				<xsl:choose>
					<xsl:when test="starts-with($path, '/')">
						<xsl:call-template name="selectNodesAndApplyNS">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="view" select="$view" />
							<xsl:with-param name="path" select="substring($path,2)" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs" />
							<xsl:with-param name="models" select="$models" />
							<xsl:with-param name="ctx" select="$namespace/../d:data" />
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="not($model)">
						<xsl:apply-templates select="$view" mode="data-bindings-ns">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="true()" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs[position()>1]" />
							<xsl:with-param name="models" select="$models" />
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="selectNodesAndApplyNS">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="view" select="$view" />
							<xsl:with-param name="path" select="$path" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs" />
							<xsl:with-param name="models" select="$models" />
							<xsl:with-param name="ctx" select="$model" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="selectNodesAndApplyNS">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" />
		<xsl:param name="model" />
		<xsl:param name="path" />
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="generated-name" />
		<xsl:param name="generated-id" />
		<xsl:param name="default-name" />
		<xsl:param name="default-id" />
		<xsl:param name="disabled" />
		<xsl:param name="params" />
		<xsl:param name="refs" />
		<xsl:param name="models" />
		<xsl:param name="ctx" />
		<xsl:variable name="after" select="substring-after($path, '/')" />
		<xsl:choose>
			<xsl:when test="$after">
				<xsl:variable name="before" select="substring-before($path, '/')" />
				<xsl:call-template name="selectNodesAndApplyNS">
					<xsl:with-param name="namespace" select="$namespace" />
					<xsl:with-param name="locale" select="$locale" />
					<xsl:with-param name="view" select="$view" />
					<xsl:with-param name="model" select="$model" />
					<xsl:with-param name="path" select="$after" />
					<xsl:with-param name="name" select="$name" />
					<xsl:with-param name="id" select="$id" />
					<xsl:with-param name="generated-name" select="$generated-name" />
					<xsl:with-param name="generated-id" select="$generated-id" />
					<xsl:with-param name="default-name" select="$default-name" />
					<xsl:with-param name="default-id" select="$default-id" />
					<xsl:with-param name="disabled" select="$disabled" />
					<xsl:with-param name="params" select="$params" />
					<xsl:with-param name="refs" select="$refs" />
					<xsl:with-param name="models" select="$models" />
					<xsl:with-param name="ctx" select="$ctx/*[name()=$before]" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="attrName" select="substring-after($path, '@')" />
				<xsl:choose>
					<xsl:when test="$attrName">
						<xsl:apply-templates select="$view" mode="data-bindings-ns">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="true()" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs[position()>1]" />
							<xsl:with-param name="models" select="$models|$ctx/@*[name()=$attrName]" />
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="$view" mode="data-bindings-ns">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="true()" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs[position()>1]" />
							<xsl:with-param name="models" select="$models|$ctx/*[name()=$path]" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="matchPredicateAndApplyNS">
		<xsl:param name="namespace" />
		<xsl:param name="locale" />
		<xsl:param name="view" />
		<xsl:param name="model" />
		<xsl:param name="path" />
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="generated-name" />
		<xsl:param name="generated-id" />
		<xsl:param name="default-name" />
		<xsl:param name="default-id" />
		<xsl:param name="disabled" />
		<xsl:param name="params" />
		<xsl:param name="refs" />
		<xsl:param name="models" />
		<xsl:param name="ctx" />
		<xsl:param name="pattern" />
		<xsl:choose>
			<xsl:when test="contains($pattern, '!=')">
				<xsl:variable name="op1" select="substring-before($pattern, '!=')"/>
				<xsl:variable name="op2" select='substring-before(substring-after($pattern, "&apos;"),"&apos;")'/>
				<xsl:variable name="attrName" select="substring-after($op1,'@')"/>
				<xsl:choose>
					<xsl:when test="$attrName">
						<xsl:apply-templates select="$view" mode="data-bindings-ns">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="true()" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs[position()>1]" />
							<xsl:with-param name="models" select="$models|$ctx[@*[name() = $attrName and . != $op2]]" />
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="$view" mode="data-bindings-ns">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="true()" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs[position()>1]" />
							<xsl:with-param name="models" select="$models|$ctx[*[name() = $op1 and . != $op2]]" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="contains($pattern, '=')">
				<xsl:variable name="op1" select="substring-before($pattern, '=')"/>
				<xsl:variable name="op2" select='substring-before(substring-after($pattern, "&apos;"),"&apos;")'/>
				<xsl:variable name="attrName" select="substring-after($op1,'@')"/>
				<xsl:choose>
					<xsl:when test="$attrName">
						<xsl:apply-templates select="$view" mode="data-bindings-ns">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="true()" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs[position()>1]" />
							<xsl:with-param name="models" select="$models|$ctx[@*[name() = $attrName and . = $op2]]"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="$view" mode="data-bindings-ns">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="true()" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs[position()>1]" />
							<xsl:with-param name="models" select="$models|$ctx[*[name() = $op1 and string(.) = $op2]]" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="starts-with($pattern, 'not(')">
				<xsl:variable name="op1" select="substring-after(substring-before($pattern, 'not('),')')"/>
				<xsl:variable name="attrName" select="substring-after($op1,'@')"/>
				<xsl:choose>
					<xsl:when test="$attrName">
						<xsl:apply-templates select="$view" mode="data-bindings-ns">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="true()" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs[position()>1]" />
							<xsl:with-param name="models" select="$models|$ctx[@*[name() != $attrName]]" />
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="$view" mode="data-bindings-ns">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="true()" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs[position()>1]" />
							<xsl:with-param name="models" select="$models|$ctx[*[name() != $op1]]" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="attrName" select="substring-after($pattern,'@')"/>
				<xsl:choose>
					<xsl:when test="$attrName">
						<xsl:apply-templates select="$view" mode="data-bindings-ns">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="true()" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs[position()>1]" />
							<xsl:with-param name="models" select="$models|$ctx[@*[name() = $attrName]]" />
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="$view" mode="data-bindings-ns">
							<xsl:with-param name="namespace" select="$namespace" />
							<xsl:with-param name="locale" select="$locale" />
							<xsl:with-param name="model" select="$model" />
							<xsl:with-param name="name" select="$name" />
							<xsl:with-param name="id" select="$id" />
							<xsl:with-param name="generated-name" select="$generated-name" />
							<xsl:with-param name="generated-id" select="$generated-id" />
							<xsl:with-param name="default-name" select="$default-name" />
							<xsl:with-param name="default-id" select="$default-id" />
							<xsl:with-param name="ignore-ns-prefix" select="true()" />
							<xsl:with-param name="disabled" select="$disabled" />
							<xsl:with-param name="params" select="$params" />
							<xsl:with-param name="refs" select="$refs[position()>1]" />
							<xsl:with-param name="models" select="$models|$ctx[*[name() = $pattern]]" />
						</xsl:apply-templates>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="selectSingleNodeNS">
		<xsl:param name="ctx" />
		<xsl:param name="path" />
		<xsl:variable name="after" select="substring-after($path, '/')" />
		<xsl:choose>
			<xsl:when test="$path='.'">
				<xsl:value-of select="$ctx" />
			</xsl:when>
			<xsl:when test="$after">
				<xsl:variable name="before" select="substring-before($path, '/')" />
				<xsl:call-template name="selectSingleNodeNS">
					<xsl:with-param name="ctx" select="$ctx/*[name()=$before]" />
					<xsl:with-param name="path" select="$after" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="attrName" select="substring-after($path, '@')" />
				<xsl:choose>
					<xsl:when test="$attrName">
						<xsl:value-of select="$ctx/@*[name()=$attrName]" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$ctx/*[name()=$path]" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>