<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="generate-id" match="*" mode="generate-id">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="."/>
		<xsl:param name="model"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-id"/>
			<xsl:variable name="id-pattern">
				<xsl:choose>
					<xsl:when test="$view/@id"><xsl:value-of select="$view/@id"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$default-id"/></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="$id-pattern='{generate-id()}'">
					<xsl:value-of select="$generated-id"/>
				</xsl:when>
				<xsl:when test="contains($id-pattern, '{generate-id()}')">
					<xsl:value-of select="concat(substring-before($id-pattern,'{generate-id()}'), $generated-id, substring-after($id-pattern,'{generate-id()}'))"/>
				</xsl:when>
				<xsl:when test="contains($id-pattern, '{name()}')">
					<xsl:if test="$model">
						<xsl:value-of select="concat(substring-before($id-pattern,'{name()}'), name($model), substring-after($id-pattern,'{name()}'))"/>
					</xsl:if>
				</xsl:when>
				<xsl:when test="contains($id-pattern, '{local-name()}')">
					<xsl:if test="$model">
						<xsl:value-of select="concat(substring-before($id-pattern,'{local-name()}'), local-name($model), substring-after($id-pattern,'{local-name()}'))"/>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$id-pattern"/>
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>
	<xsl:template name="id-generation" match="*" mode="id-generation">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="."/>
		<xsl:param name="generated-id"/>
		<xsl:choose>
			<xsl:when test="$view/d:ref">
				<xsl:variable name="path" select="translate($view/d:ref/@select,'[/]','...')"/>
				<xsl:choose>
					<xsl:when test="starts-with($path,'.')">
						<xsl:value-of select="concat($namespace, $path)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($generated-id,'.',$path)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$generated-id"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>