<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="format-date" match="xsl:template[@name='format-date']" mode="dforms-e-date">
		<xsl:param name="date" />
		<xsl:param name="locale"/>
		<xsl:if test="boolean($date) and $date !=''">
			<xsl:variable name="year" select="substring-before($date,'-')"/>
			<xsl:variable name="month" select="substring-before(substring-after($date,'-'),'-')"/>
			<xsl:variable name="day">
				<xsl:choose>
					<xsl:when test="contains($date,'T')">
						<xsl:value-of select="substring-before(substring-after(substring-after($date,'-'),'-'),'T')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="substring-after(substring-after($date,'-'),'-')"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="$locale='sk'">
					<xsl:value-of select="number($day)"/>.<xsl:value-of select="number($month)"/>.<xsl:value-of select="$year"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$month"/>/<xsl:value-of select="$day"/>/<xsl:value-of select="$year"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>