<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="generate-name" match="*" mode="generate-name">
		<xsl:param name="view" select="."/>
		<xsl:param name="model"/>
		<xsl:param name="generated-name"/>
		<xsl:param name="default-name"/>
		<xsl:variable name="name-pattern">
			<xsl:choose>
				<xsl:when test="$view/@name"><xsl:value-of select="$view/@name"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$default-name"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$name-pattern='{generate-name()}'">
				<xsl:value-of select="$generated-name"/>
			</xsl:when>
			<xsl:when test="contains($name-pattern, '{generate-name()}')">
				<xsl:value-of select="concat(substring-before($name-pattern,'{generate-name()}'), $generated-name, substring-after($name-pattern,'{generate-name()}'))"/>
			</xsl:when>
			<xsl:when test="contains($name-pattern, '{name()}')">
				<xsl:if test="$model">
					<xsl:value-of select="concat(substring-before($name-pattern,'{name()}'), name($model), substring-after($name-pattern,'{name()}'))"/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="contains($name-pattern, '{local-name()}')">
				<xsl:choose>
					<xsl:when test="$model">
						<xsl:value-of select="concat(substring-before($name-pattern,'{local-name()}'), local-name($model), substring-after($name-pattern,'{local-name()}'))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat(substring-before($name-pattern,'{local-name()}'), $view/d:ref/@select, substring-after($name-pattern,'{local-name()}'))"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$name-pattern"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="data-driven-name" match="*" mode="name-generation">
		<xsl:param name="view" select="."/>
		<xsl:param name="generated-name"/>
		<xsl:choose>
			<xsl:when test="$view/d:ref">
				<xsl:variable name="path" select="$view/d:ref/@select"/>
				<xsl:choose>
					<xsl:when test="starts-with($path,'/')">
						<xsl:value-of select="$path"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($generated-name,'/',$path)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$generated-name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>