<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="encode-uri" match="xsl:template[@name='encode-uri']" mode="utils">
		<xsl:param name="uri"/>
		<xsl:variable name="plus">
			<xsl:call-template name="replace-string">
				<xsl:with-param name="text" select="$uri"/>
				<xsl:with-param name="replace" select="'+'"/>
				<xsl:with-param name="with" select="'%2B'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="percent">
			<xsl:call-template name="replace-string">
				<xsl:with-param name="text" select="$plus"/>
				<xsl:with-param name="replace" select="'%'"/>
				<xsl:with-param name="with" select="'%25'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="eq">
			<xsl:call-template name="replace-string">
				<xsl:with-param name="text" select="$percent"/>
				<xsl:with-param name="replace" select="'='"/>
				<xsl:with-param name="with" select="'%3D'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="space">
			<xsl:call-template name="replace-string">
				<xsl:with-param name="text" select="$eq"/>
				<xsl:with-param name="replace" select="' '"/>
				<xsl:with-param name="with" select="'+'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="colon">
			<xsl:call-template name="replace-string">
				<xsl:with-param name="text" select="$space"/>
				<xsl:with-param name="replace" select="':'"/>
				<xsl:with-param name="with" select="'%3A'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="slash">
			<xsl:call-template name="replace-string">
				<xsl:with-param name="text" select="$colon"/>
				<xsl:with-param name="replace" select="'/'"/>
				<xsl:with-param name="with" select="'%2F'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="question">
			<xsl:call-template name="replace-string">
				<xsl:with-param name="text" select="$slash"/>
				<xsl:with-param name="replace" select="'?'"/>
				<xsl:with-param name="with" select="'%3F'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="amp">
			<xsl:call-template name="replace-string">
				<xsl:with-param name="text" select="$question"/>
				<xsl:with-param name="replace" select="'&amp;'"/>
				<xsl:with-param name="with" select="'%26'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="$amp"/>
	</xsl:template>
</xsl:stylesheet>