<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-v-choice" match="*[contains(name(),'choice-viewer')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale"/>
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="default-name" />
		<xsl:param name="default-id" />
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:param name="ref" select="$view/d:ref"/>
		<xsl:element name="div">
			<xsl:attribute name="class">dforms-v-choice</xsl:attribute>
			<xsl:if test="$id!=''">
				<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
			<xsl:apply-templates select="$attr" mode="add-attrs">
				<xsl:with-param name="namespace" select="$namespace" />
			</xsl:apply-templates>
			<xsl:apply-templates select="$ref/d:values" mode="dforms-e-choice-path">
				<xsl:with-param name="namespace" select="$namespace" />
				<xsl:with-param name="locale" select="$locale" />
				<xsl:with-param name="view" select="$view" />
				<xsl:with-param name="name" select="$name" />
				<xsl:with-param name="id" select="$id" />
				<xsl:with-param name="default-name" select="$default-name" />
				<xsl:with-param name="default-id" select="$default-id" />
				<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix" />
				<xsl:with-param name="model" select="$model" />
			</xsl:apply-templates>
		</xsl:element>
	</xsl:template>
	<xsl:template name="dforms-v-choice-option" match="@name[.='dforms-v-choice']" mode="dforms-e-choice">
		<xsl:param name="model" />
		<xsl:param name="ignore-ns-prefix" />
		<xsl:param name="value" />
		<xsl:param name="values" />
		<xsl:variable name="valueID">
			<xsl:call-template name="getChoiceValue">
				<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
				<xsl:with-param name="value" select="$value"/>
				<xsl:with-param name="path" select="$values/@value"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="$model and $model = $valueID">
			<xsl:call-template name="getChoiceValue">
				<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
				<xsl:with-param name="value" select="$value"/>
				<xsl:with-param name="path" select="$values/@description"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>