<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:v="http://www.dforms.org/validation/1.0"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-v-date" match="*[contains(name(),'date-viewer')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="view" select="." />
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="locale"/>
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:param name="ref" select="$view/d:ref"/>
		<xsl:element name="div">
			<xsl:attribute name="class">dforms-v-date</xsl:attribute>
				<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
				<xsl:if test="$id!=''">
					<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
				</xsl:if>
					<!-- add attributes do not remove 'if' - IE shit -->
				<xsl:if test="$attr">
					<xsl:apply-templates select="$attr" mode="add-attrs">
						<xsl:with-param name="namespace" select="$namespace" />
					</xsl:apply-templates>
				</xsl:if>
				<xsl:call-template name="format-date">
					<xsl:with-param name="date" select="$model"/>
					<xsl:with-param name="locale" select="$locale"/>
				</xsl:call-template>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>