<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-v-iframe" match="*[contains(name(),'iframe-viewer')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale"/>
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="name" />
		<xsl:param name="id" />
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:param name="ref" select="$view/d:ref"/>
		<xsl:element name="iframe">
			<xsl:attribute name="class">dforms-v-iframe</xsl:attribute>
			<xsl:attribute name="frameborder">0</xsl:attribute>
			<xsl:attribute name="src"><xsl:value-of select="$model"/></xsl:attribute>
			<xsl:if test="$id!=''">
			<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="$desc/@short-desc" mode="add-title"/>
			<xsl:apply-templates select="$attr" mode="add-attrs">
				<xsl:with-param name="namespace" select="$namespace" />
			</xsl:apply-templates>
			<xsl:text>&#160;</xsl:text>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>