<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:v="http://www.dforms.org/validation/1.0"
	xmlns:d="http://www.dforms.org/1.0">
	<xsl:template name="dforms-v-label" match="*[contains(name(),'label-viewer')]" mode="render">
		<xsl:param name="namespace" />
		<xsl:param name="locale"/>
		<xsl:param name="view" select="."/>
		<xsl:param name="model"/>
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="desc" select="d:desc[lang($locale) or not(@xml:lang)][1]"/>
		<xsl:param name="attr" select="$view/d:attr"/>
		<xsl:param name="ref" select="$view/d:ref"/>
		<xsl:variable name="isRequired" select="boolean($ref/@v:required = 'true')"/>
			<xsl:element name="label">
				<xsl:if test="$id != ''">
					<xsl:attribute name="for"><xsl:value-of select="$id"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="boolean($desc/@short-desc)">
					<xsl:message>labelView pea $desc/@short-desc:<xsl:value-of select="$desc/@short-desc"/> locale:<xsl:value-of select="$locale"/></xsl:message> 
					<xsl:attribute name="title"><xsl:value-of select="$desc/@short-desc" /></xsl:attribute>
				</xsl:if>
				<xsl:if test="$isRequired">
					<xsl:call-template name="renderRequired"/>
				</xsl:if>
				<xsl:value-of select="$model"/>
			</xsl:element>
	</xsl:template>
	<xsl:template name="renderRequired" match="xsl:template[@name='renderRequired']" mode="dforms-v-label">*&#160;</xsl:template>
</xsl:stylesheet>