<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="text/TextViewer.xsl"/>
	<xsl:import href="area/AreaViewer.xsl" />
	<xsl:import href="date/DateViewer.xsl"/>
	<xsl:import href="label/LabelViewer.xsl"/>
	<xsl:import href="choice/ChoiceViewer.xsl"/>
	<xsl:import href="image/ImageViewer.xsl"/>
	<xsl:import href="iframe/IFrameViewer.xsl"/>
	<xsl:import href="url/URLViewer.xsl" />
	<xsl:template name="renderViewer" match="*[contains(name(),'-viewer')]" mode="x-render">
		<xsl:param name="namespace" /> 
		<xsl:param name="locale" /> 
		<xsl:param name="view" select="."/>
		<xsl:param name="model" />
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="generated-name"/>
		<xsl:param name="generated-id"/>
		<xsl:param name="default-name" />
		<xsl:param name="default-id"/>
		<xsl:param name="ignore-ns-prefix"/>
		<xsl:param name="disabled"/>
		<xsl:apply-templates select="$view" mode="render">
			<xsl:with-param name="namespace" select="$namespace"/>
			<xsl:with-param name="locale" select="$locale"/>
			<xsl:with-param name="view" select="$view"/>
			<xsl:with-param name="model" select="$model"/>
			<xsl:with-param name="name" select="$name"/>
			<xsl:with-param name="id" select="$id"/>
			<xsl:with-param name="generated-name" select="$generated-name"/>
			<xsl:with-param name="generated-id" select="$generated-id"/>
			<xsl:with-param name="default-name" select="$default-name"/>
			<xsl:with-param name="default-id" select="$default-id"/>
			<xsl:with-param name="ignore-ns-prefix" select="$ignore-ns-prefix"/>
			<xsl:with-param name="disabled" select="$disabled"/>
		</xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>