<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:d="http://www.dforms.org/1.0"
	xmlns:p="http://www.dforms.org/persistence/1.0">
	<xsl:import href="../renderKit/render.xsl" />
	<xsl:output method="xml" encoding="UTF-8" media-type="text/html" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title><xsl:value-of select="/d:form/d:metadata/*[starts-with(name(),'d:') and contains(name(),'-panel')]/d:desc/@display-name"/></title>
				<meta http-equiv="Content-Type" content="text/html;charset=UTF-8"/>
				<link type="text/css" rel="stylesheet" href="../pickers/date/date.css"/>
				<link type="text/css" rel="stylesheet" href="../pickers/window.css"/>
				<link type="text/css" rel="stylesheet" href="../renderKit/actions/actions.css"/>
				<link type="text/css" rel="stylesheet" href="../renderKit/controls/controls.css"/>
				<link type="text/css" rel="stylesheet" href="../renderKit/decorators/decorators.css"/>
				<link type="text/css" rel="stylesheet" href="../renderKit/editors/editors.css"/>
				<link type="text/css" rel="stylesheet" href="../renderKit/viewers/viewers.css"/>
				<link type="text/css" rel="stylesheet" href="../renderKit/messages/messages.css"/>
				<link type="text/css" rel="stylesheet" href="../renderKit/panels/panels.css"/>
				<link type="text/css" rel="stylesheet" href="../renderKit/separators/separators.css"/>
				<script type="text/javascript" src="../doap/lang.js"></script>
				<script type="text/javascript" src="../doap/xml.js"></script>
				<script type="text/javascript" src="../doap/dom.js"></script>
				<script type="text/javascript" src="../doap/event.js"></script>
				<script type="text/javascript" src="../doap/validation.js"></script>
				<script type="text/javascript" src="../pickers/movement.js"></script>
				<script type="text/javascript" src="../pickers/window.js"></script>
				<script type="text/javascript" src="../renderKit/controls/contextHelp/contextHelp.js"></script>
				<script type="text/javascript" src="../renderKit/editors/multiSelect.js"></script>
				<script type="text/javascript" src="../renderKit/editors/radio/radio.js"></script>
				<script type="text/javascript" src="../renderKit/editors/selector/selector.js"></script>
				<script type="text/javascript" src="../renderKit/decorators/multi/multi.js"></script>
				<script type="text/javascript" src="../renderKit/decorators/form/form.js"></script>
				<script type="text/javascript" src="../renderKit/panels/combo/combo.js"></script>			
				<script type="text/javascript" src="../renderKit/panels/tab/tab.js"></script>
				<script type="text/javascript" src="../renderKit/panels/xbox/xbox.js"></script>
				<script type="text/javascript" src="../renderKit/panels/ybox/ybox.js"></script>
			</head>
			<body>
				<xsl:apply-templates select="/d:form/d:metadata/*[starts-with(name(),'d:') and contains(name(),'-panel')]" mode="data-binding">
					<xsl:with-param name="namespace" select="/d:form/@namespace"/>
					<xsl:with-param name="locale" select="/d:form/@locale"/>
					<xsl:with-param name="model" select="/d:form/d:data"/>
				</xsl:apply-templates>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>