<?xml version='1.0' encoding="UTF-8" ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:d="http://www.dforms.org/1.0"
	xmlns:p="http://www.dforms.org/persistence/1.0">
	<xsl:import href="../dforms/renderKit/render.xsl" />
	<xsl:output method="xml" encoding="UTF-8" media-type="text/html" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title><xsl:value-of select="/d:form/d:metadata/*[starts-with(name(),'d:') and contains(name(),'-panel')]/d:desc/@display-name"/></title>
				<meta http-equiv="Content-Type" content="text/html;charset=UTF-8"/>
				<link type="text/css" rel="stylesheet" href="../dforms/pickers/date/date.css"/>
				<link type="text/css" rel="stylesheet" href="../dforms/pickers/window.css"/>
				<link type="text/css" rel="stylesheet" href="../dforms/renderKit/actions/actions.css"/>
				<link type="text/css" rel="stylesheet" href="../dforms/renderKit/controls/controls.css"/>
				<link type="text/css" rel="stylesheet" href="../dforms/renderKit/decorators/decorators.css"/>
				<link type="text/css" rel="stylesheet" href="../dforms/renderKit/editors/editors.css"/>
				<link type="text/css" rel="stylesheet" href="../dforms/renderKit/viewers/viewers.css"/>
				<link type="text/css" rel="stylesheet" href="../dforms/renderKit/messages/messages.css"/>
				<link type="text/css" rel="stylesheet" href="../dforms/renderKit/panels/panels.css"/>
				<link type="text/css" rel="stylesheet" href="../dforms/renderKit/separators/separators.css"/>
				<script type="text/javascript" src="../dforms/doap/lang.js"></script>
				<script type="text/javascript" src="../dforms/doap/xml.js"></script>
				<script type="text/javascript" src="../dforms/doap/dom.js"></script>
				<script type="text/javascript" src="../dforms/doap/event.js"></script>
				<script type="text/javascript" src="../dforms/doap/validation.js"></script>
				<script type="text/javascript" src="../dforms/pickers/movement.js"></script>
				<script type="text/javascript" src="../dforms/pickers/window.js"></script>
				<script type="text/javascript" src="../dforms/renderKit/controls/contextHelp/contextHelp.js"></script>
				<script type="text/javascript" src="../dforms/renderKit/editors/multiSelect.js"></script>
				<script type="text/javascript" src="../dforms/renderKit/editors/radio/radio.js"></script>
				<script type="text/javascript" src="../dforms/renderKit/editors/selector/selector.js"></script>
				<script type="text/javascript" src="../dforms/renderKit/decorators/multi/multi.js"></script>
				<script type="text/javascript" src="../dforms/renderKit/decorators/form/form.js"></script>
				<script type="text/javascript" src="../dforms/renderKit/panels/combo/combo.js"></script>			
				<script type="text/javascript" src="../dforms/renderKit/panels/tab/tab.js"></script>
				<script type="text/javascript" src="../dforms/renderKit/panels/xbox/xbox.js"></script>
				<script type="text/javascript" src="../dforms/renderKit/panels/ybox/ybox.js"></script>
			</head>
			<body>
				<xsl:apply-templates select="/d:form/d:metadata/*[starts-with(name(),'d:') and contains(name(),'-panel')]" mode="data-binding">
					<xsl:with-param name="namespace" select="/d:form/@namespace"/>
					<xsl:with-param name="locale" select="/d:form/@locale"/>
					<xsl:with-param name="model" select="/d:form/d:data"/>
				</xsl:apply-templates>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>