#ifndef EXCEPTIONS_H_
#define EXCEPTIONS_H_

class pramException: public std::exception {
protected:
	const std::string str;
public:
	pramException(std::string error) throw(): str(error) {}
	~pramException() throw() {}

	virtual const char* what() const throw () {
		return str.c_str();
	}
};

class memoryException: public pramException {
public:
	memoryException(std::string error) throw(): pramException(error) {}
};

class memAccessException: public memoryException {
public:
	memAccessException(std::string error) throw(): memoryException(error) {}
};

class badOpException: public pramException {
public:
	badOpException(std::string error) throw(): pramException(error) {}
};

class symbolTableException: public pramException {
public:
	symbolTableException(std::string error) throw(): pramException(error) {}
};

class compileException: public pramException {
public:
	compileException(std::string error) throw(): pramException(error) {}
};

#endif /* EXCEPTIONS_H_ */
