#ifndef PROCESS_H_
#define PROCESS_H_

enum ProcessState {ps_ok, ps_child, ps_sync, ps_sync_begin, ps_exit, ps_if_true, ps_if_false, ps_call_par, ps_setp};

#include <stack>
#include <istream>
#include <iostream>

#include "frame.h"
#include "SyncObj.h"


class frame;
class SyncObj;

/**
** Trieda reprezentujuca jeden proces. 
*/
class Process {
private:
	std::stack<frame *> frames; //zasobnik volani
	memory& shared; // zdielana pamat
	SymbolTable *functions;
	std::vector<CodeObject *> &codeObjects;
	SyncObj* syncObj; // prisluchajuci synchronizacny objekt
	ProcessState processState; 
	std::vector<Process *> children;
	std::istream& input;
	unsigned int callAddr;
public:
	Process(memory& shared, SymbolTable* functions, std::vector<CodeObject *> &codeObjects, std::istream& input, std::string fName);
	Process( memory& shared, SymbolTable* functions, std::vector<CodeObject *> &codeObjects, std::istream& input, frame* _frame);
	Process( memory& shared, SymbolTable* functions, std::vector<CodeObject *> &codeObjects, std::istream& input);
	virtual ~Process();
	memObject* getShared(unsigned int position);
	void setShared(memObject* mObj, unsigned int position) throw(memAccessException);
	void doInstruction() throw(pramException);
	void run();
	SyncObj* getSyncObj();
	void setSyncObj(SyncObj* newSyncObj);
	ProcessState getProcessState();
	std::vector<Process *>& getChildren();
	unsigned int getCallAddr();
	void pushFrame(frame* f);
	memObject* exprStackPop();
};

#endif /* PROCESS_H_ */

