#include "Scheduler.h"

using namespace std;

Scheduler::Scheduler(memory& shared, SymbolTable* functions, std::vector<CodeObject *> &codeObjects, std::istream &input)
	: shared(shared), functions(functions), codeObjects(codeObjects), input(input)
{

}

Scheduler::~Scheduler() {
}

void Scheduler::runInit() {
	try {
		functions->getIndex("init");
	} catch (symbolTableException &e) {
		processorCount = 10; // nejake default nastavenie
		return;
	}
	processorCount = 1;
	Process* initProcess = new Process(shared, functions, codeObjects, input, string("init"));
	(new SyncObj())->addProcess(initProcess);
	active.insert(initProcess);
	inInit = true;
	run();
	inInit = false;
}

void Scheduler::runFinal() {
	try {
		functions->getIndex("final");
	} catch (symbolTableException &e) {
		return;
	}
	Process* initProcess = new Process(shared, functions, codeObjects, input, string("final"));
	(new SyncObj())->addProcess(initProcess);
	active.insert(initProcess);
	inInit = true;
	unsigned int stime = time,swtTime = wtTime,swork = work;
	run();
	time = stime; wtTime = swtTime; work = swork;
	inInit = false;
}


void Scheduler::runMain() {
	time = 0; // init nas nezaujima
	wtTime = 0;
	work = 0;
	Process* mainProcess = new Process(shared, functions, codeObjects, input, string("main"));
	(new SyncObj())->addProcess(mainProcess);
	active.insert(mainProcess);
	run();
}


void Scheduler::doBatch() throw(pramException) {
	vector<Process *> processes(active.begin(), active.end());

	unsigned int activeProcess = 0;

	while (activeProcess < processes.size()) {
		time++;
		for (unsigned int processor = 0; processor < processorCount && activeProcess < processes.size(); processor++) {
			work++;

			Process* currProcess = processes[activeProcess];
			currProcess->doInstruction();

			switch (currProcess->getProcessState()) {
			case ps_ok: break;
			case ps_child: {
				if (inInit) {
					throw badOpException("Pardo loop in init/final not allowed");
				}
				std::vector<Process *>& children = currProcess->getChildren();
				if (children.size() == 0) {
					break; // inak by sa vytvoril prazdny syncObject, ktory by sa neodstranil a rodic by spal
				}
				active.erase(currProcess);
				SyncObj* syncObj = currProcess->getSyncObj()->trueChild();
				for (int j = 0; j < children.size(); j++) {
					active.insert(children[j]);
					syncObj->addProcess(children[j]);
				}
				break;
			}
			case ps_sync: {
				active.erase(currProcess);
				SyncObj* syncObj = currProcess->getSyncObj();
				syncObj->removeProcess(currProcess);
				SyncObj* parent = syncObj->getParent();
				if (parent == NULL) {
					throw badOpException("Internal error: sync on root syncObject");
				}
				parent->addProcess(currProcess);

				tryRemove(syncObj);
				break;
			}
			case ps_exit: {
				active.erase(currProcess);
				SyncObj* syncObj = currProcess->getSyncObj();
				syncObj->removeProcess(currProcess);

				tryRemove(syncObj);
				delete currProcess;
				break;
			}
			case ps_if_false: {
				SyncObj* syncObj = currProcess->getSyncObj();
				syncObj->removeProcess(currProcess);
				syncObj->falseChild()->addProcess(currProcess);
				break;
			}
			case ps_if_true: {
				SyncObj* syncObj = currProcess->getSyncObj();
				syncObj->removeProcess(currProcess);
				syncObj->trueChild()->addProcess(currProcess);
				break;
			}
			case ps_sync_begin: { //to iste ako ps_if_true
				SyncObj* syncObj = currProcess->getSyncObj();
				syncObj->removeProcess(currProcess);
				syncObj->trueChild()->addProcess(currProcess);
				break;
			}
			case ps_call_par: {
				if (inInit) {
					throw badOpException("Parallel procedures in init/final are not allowed");
				}
				if (activeProcCount() > 1) {
					throw badOpException("Parallel procedure called with multiple active processes!");
				}
				SyncObj* syncObj = currProcess->getSyncObj()->trueChild();
				active.erase(currProcess);

				bool first = true;
				std::vector<memObject *> args;
				for (unsigned int j = 0; j < processorCount; j++) {
					Process* p = new Process(shared, functions, codeObjects, input);
					frame* f = new frame(*p, *codeObjects[currProcess->getCallAddr()], input);

					if (first) {
						for (unsigned int k = 0; k < f->getArgCount(); k++) { //params
							args.push_back(currProcess->exprStackPop());
						}
						first = false;
					}
					for (unsigned int k = 0; k < args.size(); k++) { //add params
						f->exprStackPush(args[k]->get());
					}

					f->exprStackPush(new memInteger(processorCount));
					f->exprStackPush(new memInteger(j));

					p->pushFrame(f);
					syncObj->addProcess(p);
					active.insert(p);
				}
				for (unsigned int k = 0; k < args.size(); k++) {
					delete args[k];
				}

				break;
			}
			case ps_setp: {
				if (!inInit) {
					throw badOpException("setP allowed only in init");
				}
				memInteger* mObj = dynamic_cast<memInteger *>(currProcess->exprStackPop());
				if (mObj == NULL) {
					throw badOpException("setP called with non-integer argument");
				}
				setProcessorCount(mObj->getValue());
				delete mObj;
				break;
			}
			}
			activeProcess++;
		}
	}

	shared.resolveMemAccess();
}

void Scheduler::tryRemove(SyncObj* syncObj) {
	if (syncObj->empty()) {
		syncObj->remove();
		SyncObj* parent = syncObj->getParent();
		if (parent != NULL && parent->canWakeUp()) {
			std::set<Process *>& procs = parent->getProcesses();
			active.insert(procs.begin(), procs.end());
		}
		delete syncObj;
	}
}

void Scheduler::setActive(Process* process) {
	active.insert(process);
}

bool Scheduler::hasNext() {
	return active.size() > 0;
}

void Scheduler::run() throw(pramException) {
	while (hasNext()) {
		doBatch();
		wtTime++;
	}
}

unsigned int Scheduler::activeProcCount() {
	return active.size();
}

void Scheduler::setProcessorCount(unsigned int pCount) {
	processorCount = pCount;
}

unsigned int Scheduler::getTime() {
	return time;
}

unsigned int Scheduler::getWTTime() {
	return wtTime;
}

unsigned int Scheduler::getWork() {
	return work;
}

