#ifndef SCHEDULER_H_
#define SCHEDULER_H_

#include "memory.h"
#include "symboltable.h"
#include "codeobject.h"
#include "Process.h"

#include <vector>
#include <set>
#include <algorithm>
#include <istream>

/**
** Planovac uloh. 
*/
class Scheduler {
private:
	memory& shared;
	SymbolTable *functions;
	std::vector<CodeObject *> &codeObjects;
	std::set<Process *> active;
	std::istream& input;
	void doBatch() throw(pramException);
	void tryRemove(SyncObj* syncObj);
	bool hasNext();
	unsigned int processorCount;
	unsigned int time;
	unsigned int wtTime;
	unsigned int work;
	bool inInit;
	void run() throw(pramException);
public:
	Scheduler(memory& shared, SymbolTable* functions, std::vector<CodeObject *> &codeObjects, std::istream& input);
	virtual ~Scheduler();
	void setActive(Process* process);
	unsigned int activeProcCount();
	void setProcessorCount(unsigned int pCount);
	unsigned int getTime();
	unsigned int getWTTime();
	unsigned int getWork();
	void runInit();
	void runMain();
	void runFinal();
};

#endif /* SCHEDULER_H_ */
