#include "codeobject.h"

#include <sstream>

CodeObject::CodeObject(std::string name, unsigned int numArgs, bool parallel): name(name), numArgs(numArgs), parallel(parallel) {
	syncDepth = 0;
}

std::string CodeObject::getName() {
	return name;
}

void CodeObject::addInstruction(InstrPair instruction) {
	adjustSyncDepth(instruction.first);
	code.push_back(instruction);
}

/**
 *  nasleduje hack na to, aby sa nepoplietol strom syncObjektov ak pride return
 *  budeme ratat hlbku sync blokov a ak pride RET, tak pred neho dame tolko SYNCov,
 *  aby sa procesy zosynchronizovali.
 */
void CodeObject::adjustSyncDepth(Instructions instr) {
	switch (instr) {
	case JMPFALSE_SYNC:
	case SYNC_BEGIN: {
		syncDepth++;
		break;
	}
	case SYNC: {
		syncDepth--;
		break;
	}
	case RET: {
		for (int i = 0; i < syncDepth; i++) {
			code.push_back(std::make_pair(SYNC, noArgument));
		}
		break;
	}
	default: {
		break;
	}
	}
}


/**
 * sluzi na rezervovanie instrukcie, ktore sa pouzije pre backpatchingu. malo by sa to pouzit len s JMP*.
 */
int CodeObject::reserveInstruction(Instructions JMPType) {
	adjustSyncDepth(JMPType);
	code.push_back(std::make_pair(JMPType, 0));
	return code.size() - 1;
}

int CodeObject::getCurrentAddress() {
	return code.size();// > 0 ? code.size() - 1 : 0;
}

void CodeObject::backPatch(int address) {
	code[address].second = code.size();
}

int CodeObject::addLocal(std::string name, VarType varType) throw(symbolTableException) {
	return locals.addName(name, varType);
}

int CodeObject::getLocalAddress(std::string name) throw(symbolTableException) {
	return locals.getIndex(name); 
}

unsigned int CodeObject::getNumArgs() {
	return numArgs;
}


// dump objektu pre debugovanie
std::string CodeObject::dump() {
	std::ostringstream result;
	const char *opNames[] = {"RET", "SYS", "CALL", "PARDO",
			"LOAD_CONST", "LOAD_LOC", "LOAD_SHARE",
			"STORE_LOC", "STORE_SHARE", "POP",
			"STORE_ARR_LOC", "STORE_ARR_GLOB", "STORE_ARR_SHARE",
			"JMP", "JMPFALSE", "JMPTRUE",
			"ADD", "SUB", "MUL", "DIV", "SHL", "SHR", "AND", "OR", "XOR", "LAND", "LOR", "NOT",
			"EQ", "LESS", "GRT", "LEQ", "GEQ",
			"SIZEOF", "SETP",
			"DEREF", "NEW", "DELETE",
			"SYNC", "JMPFALSE_SYNC", "SYNC_BEGIN"};
	for (unsigned int i = 0; i < code.size(); i++) {
		result << opNames[code[i].first]
				<< " " << code[i].second << std::endl;
	}
	return result.str();
}

InstrPair CodeObject::getInstructionAt(unsigned int position) {
	return code[position];
}

unsigned int CodeObject::getInstructionCount() {
	return code.size();
}

memory* CodeObject::getMemory() {
	return locals.getMemory();
}

int CodeObject::addPardoArg(std::string name) {
	pardoArgs.push_back(name);
	return addLocal(name, v_int);
}

std::vector<std::string> CodeObject::getPardoArgs() {
	return pardoArgs;
}
unsigned int CodeObject::getPardoArgCount() {
	return pardoArgs.size();
}

bool CodeObject::isParallel() {
	return parallel;
}
