#include "context.h"

#include <iostream>

Context::Context(SymbolTable &share, SymbolTable &functions, std::vector<CodeObject *> &codeObjects):
	 share(share), functions(functions), codeObjects(codeObjects), activeCodeObject(0), currentPardoFunction(0) {


}

void Context::addSyntaxtTreeRoot(SyntaxTreeNode *root) {
	rootNode = root;
}

void Context::generateCode() {
	rootNode->generateCode(*this);
}

int Context::addLocal(std::string name, VarType varType) {
	return codeObjects[activeCodeObject]->addLocal(name, varType);
}

int Context::addShared(std::string name, VarType varType) {
	return share.addName(name, varType);
}

addrAndNamespace Context::getAddress(std::string name) throw(symbolTableException) {
	addrAndNamespace result;
	try {
		result = std::make_pair(codeObjects[activeCodeObject]->getLocalAddress(name), local);
	} catch (symbolTableException &e) {
		try {
			result = std::make_pair(share.getIndex(name), shared);
		} catch  (symbolTableException &ee) {
			throw;
		}
	}
	return result;
}

int Context::newCodeObject(std::string name, unsigned int argCount, bool parallel) {
	codeObjects.push_back(new CodeObject(name, argCount, parallel));
	activeCodeObject = codeObjects.size() - 1;
	return activeCodeObject;
}

int Context::addFunction(std::string name, VarType varType, unsigned int argCount, bool parallel) throw(symbolTableException) {
	int address = newCodeObject(name, argCount, parallel);
	functions.addNameWithValue(name, address, varType);
	return address;
}

int Context::getFunction(std::string name) throw(symbolTableException) {
	return functions.getIndex(name);
}

unsigned int Context::getNumArgs(std::string name) {
	try {
		return codeObjects[functions.getIndex(name)]->getNumArgs();
	}catch (symbolTableException &e) {
		return 0;
	}
}

std::string Context::getCurrentFunction() {
	return codeObjects[activeCodeObject]->getName();
}

int Context::addPardoFunction() {
	int numArgs = 1; //default pocet parametrov je 1 -> pocitadlo cyklu
	if (codeObjects[activeCodeObject]->getName()[0] == '$') { // ak volajuci je tiez v pardo cykle, tak zdedime parametre
		numArgs = codeObjects[activeCodeObject]->getNumArgs() + 1;
	}
	std::ostringstream oss;
	oss << "$pardo" << currentPardoFunction;
	currentPardoFunction++;
	return addFunction(oss.str(), v_int, numArgs);
}

void Context::switchToFunction(std::string name) throw (symbolTableException) {
	activeCodeObject = getFunction(name);
}

void Context::addInstruction(Instructions instruction, ArgumentType argument) {
	codeObjects[activeCodeObject]->addInstruction(std::make_pair(instruction, argument));
}

int Context::reserveInstruction(Instructions JMPType) {
	return codeObjects[activeCodeObject]->reserveInstruction(JMPType);
}

void Context::backPatch(int address) {
	codeObjects[activeCodeObject]->backPatch(address);
}

int Context::getCurrentAddress() {
	return codeObjects[activeCodeObject]->getCurrentAddress();
}

int Context::addPardoArg(std::string name) {
	return codeObjects[activeCodeObject]->addPardoArg(name);
}

std::vector<std::string> Context::getPardoArgs() {
	return codeObjects[activeCodeObject]->getPardoArgs();
}

bool Context::isInParProcedure() {
	return codeObjects[activeCodeObject]->isParallel();
}

void Context::freeSyntaxTree() {
	delete rootNode;
}
