#include "frame.h"

frame::frame(Process& process, CodeObject &codeobject, std::istream &input): code(codeobject), IP(0), process(process), input(input) {
	locals = code.getMemory();
}

frame::~frame() {
	while (exprStack.size() > 0) {
		delete exprStack.top();
		exprStack.pop();
	}
	delete locals;
}

InstrPair frame::getNextInstruction() {
	return code.getInstructionAt(IP++);
}

bool frame::hasNexInstruction() {
	return IP < code.getInstructionCount();
}

memObject* frame::exprStackPop() {
	if (exprStack.size() == 0) {
		throw badOpException("Expression stack empty!");
	}
	memObject* mObj = exprStack.top();
	exprStack.pop();
	return mObj;
}

void frame::exprStackPush(memObject* mObj) {
	exprStack.push(mObj);
}


void frame::doInstruction() throw(pramException) {
	fs = fs_ok;
	if (!hasNexInstruction()) {
		fs = fs_exit;
		return;
	}
	InstrPair instrPair = code.getInstructionAt(IP++);
	unsigned int addr = instrPair.second;
	Instructions instr = instrPair.first;
	switch (instr) {
	case RET: {
		fs = fs_ret;
		break;
	}
	case SYS: {
		switch ((SysCalls)addr) {
			// nacita jedno cislo na stack
			case READ: {
				int read;
				if (input  >> read) {
					exprStackPush(new memInteger(read));
				} else {
					throw badOpException("Reading failed. Probably non-integer character or end of input.");
				}
				break;
			}
		    // vypise hodnotu zo stacku
			case WRITE_: {
				memInteger* mObj = (memInteger *)exprStackPop();
				std::cout << mObj->getValue() << std::endl;
				delete mObj;
				break;
			}
			}
			break;
		}
	//zavola funkciu. parametre na stacku:
	//  argumenty funkcie (v opacnom poradi)
	//addr = adresa funkcie
	case CALL: {
		fs = fs_call;
		break;
	}
    //vytvorenie procesov. parametre:
	//  max
	//  min
	//  zdedene argumenty (pre vnorene pardo cykly)
	//addr = adresa funkcie
	case PARDO: {
		fs = fs_pardo;
		break;
	}
	// nacita konstantu ktora je v addr
	case LOAD_CONST: exprStack.push(new memInteger((int)addr)); break;
	// nacita premennu ktorej adresa je v addr
	case LOAD_LOC: exprStack.push(locals->get(addr)); break;
	// nacita zdielanu premennu ktorej adresa je v addr
	case LOAD_SHARE: exprStack.push(process.getShared(addr)); break;
	// ulozi premennu ktorej adresa je v addr
	case STORE_LOC:  {
			memObject* mObj = exprStackPop();
			locals->add(mObj, addr);
			delete mObj;
			break;
		}
	// ulozi zdielanu premennu ktorej adresa je v addr
	case STORE_SHARE: {
			memObject* mObj = exprStackPop();
			process.setShared(mObj, addr);
			delete mObj;
			break;
		}
	// vyhodi jeden prvok zo stacku
	case POP: {
			delete exprStackPop();
			break;
	}
	// ulozi pole. parametre
	//   pole
	//   index
	//   objekt ktory sa ma ulozit
	case STORE_ARR_LOC: {
		memArray* mArr = dynamic_cast<memArray *>(exprStackPop());
		memInteger* index = dynamic_cast<memInteger *>(exprStackPop());
		memObject* mObj = exprStackPop();
		if (mArr == NULL || index == NULL) {
			throw badOpException("ERROR: bad types (array store)");
		}
		mArr->set(mObj, index->getValue());
		delete mArr; delete index; delete mObj;
		break;
	}
	case STORE_ARR_GLOB:// nepouzite, k premennym sa vzdy pristupuje cez stack
	case STORE_ARR_SHARE://
	case JMP: IP = addr; break;
	// skoc na addr ak hodnota na stacku je nepravda - 0
	case JMPFALSE: {
			memObject* mObj = exprStackPop();
			if (!mObj->toBool()) {
				IP = addr;
			}
			delete mObj;
			break;
		}
	// skoc na addr ak hodnota na stacku je pravda - ine ako 0
	case JMPTRUE: {
			memObject* mObj = exprStackPop();
			if (mObj->toBool()) {
				IP = addr;
			}
			delete mObj;
			break;
		}
	// vsetky binarne operacie maju dva parametre na stacku a tam aj vratia vysledok
	case ADD: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(add, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case SUB: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(sub, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case MUL: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(mul, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case DIV: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(_div, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case EQ: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(eq, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case LESS: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(less, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case GRT: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(grt, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case LEQ: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(leq, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case GEQ: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(geq, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case SHR: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(shr, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case SHL: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(shl, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case AND: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(_and, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case OR: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(_or, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case XOR: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(_xor, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case LAND: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(land, mObj2));
			delete mObj2; delete mObj1;
			break;
		}
	case LOR: {
			memObject* mObj2 = exprStackPop(); //vyberame v opacnom poradi
			memObject* mObj1 = exprStackPop();
			exprStack.push(mObj1->doOperation(lor, mObj2));
			delete mObj2; delete mObj1;
			break;
	}
	//neguje hodnotu na stacku
	case NOT: {
		memObject* mObj = exprStackPop();
		exprStack.push(mObj->doOperation(_not, NULL));
		delete mObj;
		break;
	}
	// vrati velkost pola na zasobniku
	case SIZEOF: {
		memObject* mObj = exprStackPop();
		exprStack.push(mObj->getSize());
		delete mObj;
		break;
	}
	// indexovanie pola. parametre:
	//   pole
	//   index
	case DEREF: {
		memObject* mArr = exprStackPop();
		memObject* mInt = exprStackPop();
		exprStackPush(mArr->doOperation(deref, mInt));
		delete mArr; delete mInt;
		break;
	}
	// vytvorenie noveho pola, ktory sa ulozi na stack. parametre:
	//   velkost
	case NEW: {
		memInteger* mInt = dynamic_cast<memInteger *>(exprStackPop());
		if (mInt == NULL) {
			throw badOpException("BUG: new called with non-integer");
		}
		memArray* mObj = new memArray();
		mObj->allocArray(mInt->getValue(), (VarType)addr);
		exprStackPush(mObj);
		delete mInt;
		break;
	}
	// uvolni pole na stacku
	case DELETE: {
		memArray* mObj = dynamic_cast<memArray *>(exprStackPop());
		if (mObj == NULL) {
			throw badOpException("Trying to delete a non array variable");
		} else {
			mObj->free();
		}
		delete mObj;
		break;
	}
	// synchronizovany skok ak nepravda
	case JMPFALSE_SYNC: {
		memObject* mObj = exprStackPop();
		if (!mObj->toBool()) {
			IP = addr;
			fs = fs_if_false;
		} else {
			fs = fs_if_true;
		}
		delete mObj;
		break;
	}
	// synchronizacia na konci bloku
	case SYNC: {
		fs = fs_sync;
		break;
	}
	// zaciatok synchronizovaneho bloku
	case SYNC_BEGIN: {
		fs = fs_sync_begin;
		break;
	}
	// nastav pocet procesorov
	case SETP: {
		fs = fs_setp;
		break;
	}
	}
}

FrameState frame::getFrameState() {
	return fs;
}

unsigned int frame::getArgCount() {
	return code.getNumArgs();
}
