#ifndef FRAME_H_
#define FRAME_H_

#include <stack>
#include <istream>
#include <iostream>

#include "codeobject.h"
#include "memory.h"
#include "memObject.h"
#include "memInteger.h"
#include "Process.h"


class Process;

enum FrameState {fs_ok, fs_ret, fs_call, fs_pardo, fs_exit, fs_if_true, fs_if_false, fs_sync, fs_sync_begin, fs_setp};

/**
** Trieda reprezentuje jedno aktivovanie funkcie na zasobniku volani. 
*/
class frame {
private:
	CodeObject& code;
	memory* locals;
	Process& process;
	unsigned int IP; //instruction pointer
	std::stack<memObject*> exprStack;
	FrameState fs;
	std::istream& input;
	memObject* exprStackPop();
public:
	friend class Process;
	void exprStackPush(memObject* mObj);
	frame(Process& process, CodeObject& codeobject, std::istream& input);
	virtual ~frame();
	void doInstruction() throw(pramException);
	InstrPair getNextInstruction();
	bool hasNexInstruction();
	FrameState getFrameState();
	unsigned int getArgCount();
};

#endif /* FRAME_H_ */
