#include "memArray.h"

memArray::memArray(std::string name): memObject(name) {
}

memArray::~memArray() {
	// pozor, tu sa arr nemaze. moze byt referencovane v inom objekte. maze sa len v free(), ak programator zavola delete.
}

void memArray::allocArray(int size, VarType varType) {
	arr = new std::vector<memObject *>();
	for (int i = 0; i < size; i++) {
		memObject* mObj = NULL;
		switch (varType) {
			case v_int: mObj = new memInteger(0, name); break;
			case v_arr: mObj = new memArray(name); break;
		}
		mObj->setMemory(mem);
		arr->push_back(mObj);
	}
}

void memArray::free() {
	for (int i = 0; i < arr->size(); i++) {
		memObject* mObj = (*arr)[i];
		if (mObj != NULL) {
			delete mObj;
		}
	}
	arr->resize(0);
}

memObject* memArray::doOperation(operations op, memObject* obj) throw(pramException) {
	if (op == deref) {
		memInteger* otherInt = dynamic_cast<memInteger *>(obj);
		if (otherInt == NULL) {
			throw badOpException("");
		}
		int index = otherInt->getValue();
		if (index >= arr->size()) {
			std::stringstream ss;
			ss << "Index out of range: " << name << "[" << index << "]";
			throw badOpException(ss.str());
		}
		memObject* mObj = (*arr)[index];
		if (mObj == NULL) {
			throw memoryException("Null pointer dereference");
		}
		return mObj->get();
	}
	throw badOpException("Unsupported operation for array: " + name);
}

void memArray::setObj(memObject* mObj) throw(badOpException) {
	memArray* mArray = dynamic_cast<memArray *>(mObj);
	if (mArray == NULL) {
		throw badOpException("Type mismatch: assigning non-array type to array " + name);
	}

	if (mArray->mem != NULL && getMemType() != mArray->getMemType()) { // aby sa nedalo priradovat polia z lokalnej do zdielanej pamate a naopak
		throw badOpException("Namespace mismatch (shared - local) " + name);
	}

	arr = mArray->arr;
	for (int i = 0; i < arr->size(); i++) {
		(*arr)[i]->setMemory(mem);
		(*arr)[i]->setName(name);
	}
}

memObject* memArray::getObj() {
	return new memArray(*this);
}

void memArray::set(memObject * mObj, unsigned int index) {
	if (index >= arr->size()) {
		std::stringstream ss;
		ss << "Index out of range: " << name << "[" << index << "]";
		throw badOpException(ss.str());
	}
	(*arr)[index]->set(mObj);
}

bool memArray::toBool() {
	return arr->size() > 0;
}

void memArray::addMemRead(memory& mem) throw (memoryException){
// nic nespravime. citanie pola neriesime, aby sa dalo dereferencovat.
}

unsigned int memArray::getArrSize() {
	return arr->size();
}

bool memArray::equalsTo(memObject* mObj) {
	memArray* otherArr = dynamic_cast<memArray *>(mObj);
	if (otherArr == NULL || otherArr->getArrSize() != getArrSize()) {
		return false;
	}
	bool result = true;
	for (unsigned int i = 0; i < arr->size(); i++) {
		result = result && (*arr)[i]->equalsTo((*otherArr->arr)[i]);
	}
	return result;
}

memObject* memArray::getSize() {
	return new memInteger(getArrSize());
}
