#ifndef MEMARRAY_H_
#define MEMARRAY_H_

#include "memObject.h"
#include "memInteger.h"
#include "memory.h"
#include "symboltable.h"

#include <vector>
#include <sstream>

class memArray: public memObject {
protected:
	std::vector<memObject *>* arr;
	virtual void addMemRead(memory& mem) throw(memoryException);
	virtual void setObj(memObject * mObj) throw(badOpException);
public:
	virtual memObject* getObj();
	memArray(std::string name = "");
	virtual ~memArray();
	virtual memObject* doOperation(operations op, memObject* obj) throw(pramException);
	void set(memObject * mObj, unsigned int index);
	virtual bool toBool();
	void allocArray(int size, VarType varType);
	void free();
	virtual bool equalsTo(memObject* mObj);
	unsigned int getArrSize();
	virtual memObject* getSize();
};

#endif /* MEMARRAY_H_ */
