#include "memInteger.h"


memInteger::memInteger(int value, std::string name): value(value), memObject(name) {
}

memInteger::~memInteger() {
}

memObject* memInteger::doOperation(operations op, memObject* obj) throw(pramException) {
	if (op == _not) {
		return new memInteger(toBool() ? 0 : 1);
	}
	memInteger* otherInt = dynamic_cast<memInteger *>(obj);
	if (otherInt == NULL) {
		throw new badOpException("Operation not supported. Variables: " + name + ", " + obj->getName());
	}
	memObject* result = NULL;
	switch (op) {
		case add: result = new memInteger(value + otherInt->value); break;
		case sub: result = new memInteger(value - otherInt->value); break;
		case mul: result = new memInteger(value * otherInt->value); break;
		case _div: result = new memInteger(value / otherInt->value); break;
		case eq: result = new memInteger(value == otherInt->value); break;
		case less: result = new memInteger(value < otherInt->value); break;
		case grt: result = new memInteger(value > otherInt->value); break;
		case leq: result = new memInteger(value <= otherInt->value); break;
		case geq: result = new memInteger(value >= otherInt->value); break;
		case shl: result = new memInteger(value << otherInt->value); break;
		case shr: result = new memInteger(value >> otherInt->value); break;
		case _and: result = new memInteger(value & otherInt->value); break;
		case _or: result = new memInteger(value | otherInt->value); break;
		case _xor: result = new memInteger(value ^ otherInt->value); break;
		case land: result = new memInteger(toBool() && otherInt->toBool() ? 1 : 0); break;
		case lor: result = new memInteger(toBool() || otherInt->toBool() ? 1 : 0); break;
	}
	if (result == NULL) {
		throw new badOpException("Unsupported operation for type integer. Variables: " + name + ", " + obj->getName());
	}
	return result;
}

int memInteger::getValue() {
	return value;
}
memObject* memInteger::getObj() {
	return new memInteger(value);
}

void memInteger::setObj(memObject * mObj) throw(badOpException) {
	memInteger* mInt = dynamic_cast<memInteger *>(mObj);
	if (mInt == NULL) {
		throw badOpException("Type mismatch: assigning non-integer type to integer variable: " + name);
	}
	this->value = mInt->value;
}

bool memInteger::toBool() {
	return value != 0;
}

void memInteger::addMemRead(memory& mem) throw(memoryException) {
	mem.addRead(this);
}

bool memInteger::equalsTo(memObject* mObj) {
	memInteger* otherInt = dynamic_cast<memInteger *>(mObj);
	return otherInt != NULL && value == otherInt->getValue();
}

memObject* memInteger::getSize() {
	return new memInteger(1);
}
