#include "memObject.h"

memObject::memObject(std::string name): name(name) {
	mem = NULL;
	srand ( time(NULL) );
}

std::string memObject::getName() {
	return name;
}

void memObject::setName(std::string newName) {
	name = newName;
}

void memObject::set(memObject* mObj) throw(pramException) {
	if (mem != NULL) {
		addMemWrite(mObj);
	}
	dirtyWrite = true;
	if (mem == NULL || mem->getMemType() == mt_local) {
		setObj(mObj);
		//toto nerobime pre zdielane, zapis sa spravi az v resolveMem.
		//jednak sa vyriesi konflikty a tiez to predide konfliktom read-write, lebo write sa robi az na konci kola.
	}
}

memObject* memObject::get() throw(pramException) {
	if (mem != NULL) {
		addMemRead(*mem);
	}
	dirtyRead = true;
	return getObj();
}

void memObject::setMemory(memory* newMem) {
	mem = newMem;
}

void memObject::addMemWrite(memObject* mObj)  throw(memAccessException){
	writes.push_back(mObj->getObj());
	mem->addWrite(this, mObj);
}

MemType memObject::getMemType() {
	return mem != NULL ? mem->getMemType() : mt_local;
}

void memObject::resolveMem() throw(memAccessException) {
	if (writes.size() == 0) {
		return;
	}
	if (mem->getMemType() == mt_crcw_arb) {
		unsigned int r = rand() % writes.size();
		setObj(writes[r]);
	} else if (mem->getMemType() == mt_crcw_comm) {
		memObject *mObj = writes[0];
		for (int i = 0; i < writes.size(); i++) {
			if (!mObj->equalsTo(writes[i])) {
				throw memAccessException("Concurrent write with different values (common CRCW)! Variable: " + getName());
			}
		}
		setObj(mObj);
	} else {
		setObj(writes[0]);
	}
	for (int i = 0; i < writes.size(); i++) {
		delete writes[i];
	}
	writes.clear();
}
