#ifndef MEMOBJECT_H
#define MEMOBJECT_H

#include <exception>
#include <vector>
#include <string>
#include <stdlib.h>
#include <time.h>

#include "memory.h"
#include "Exceptions.h"

class memory;

enum operations {add, sub, mul, _div, deref, eq, less, grt, leq, geq, shr, shl, _and, _or, _xor, land, lor, _not};

/**
** Zakladny objekt pamate. Pracuje sa s nou hlavne pomocou metody get a set. Pamat je tvoreny polom
** takychto objektov, ktorym sa nastavuju hodnoty. Na stack sa nacitava vzdy kopia objektu.
*/
class memObject {
protected:
	bool dirtyRead;
	bool dirtyWrite;
	std::string name;
	memory* mem;
	std::vector<memObject *> writes;

	// tieto metody sa zavolaju, ked sa robi get/set. V zdedenych triedach treba implementovat podla toho, ci sa maju riesit
	// konflikty alebo nie. Vid memArray a memInteger.
	virtual void addMemRead(memory& mem) throw (memoryException) = 0;
	virtual void addMemWrite(memObject* mObj) throw(memAccessException);

	virtual void setObj(memObject* mObj) throw(badOpException) = 0 ;
public:
	// tato metoda vracia kopiu objektu
	virtual memObject* getObj() = 0;
	virtual ~memObject() {};
	virtual memObject* doOperation(operations op, memObject* obj) throw(pramException) = 0;
	memObject(std::string name);
	void set(memObject * mObj) throw(pramException);
	memObject* get() throw(pramException);
	std::string getName();
	void setName(std::string newName);
	virtual bool toBool() = 0;
	void setMemory(memory* newMem);
	// funkcia vrati true, ak oba objekty obsahuju tu istu hodnotu
	virtual bool equalsTo(memObject* mObj) = 0;
	MemType getMemType();
	virtual memObject* getSize() = 0;
	void resolveMem() throw(memAccessException);
};

#endif
