#include "memory.h"

memory::memory(std::vector<memObject *>* memArr, MemType memType) {
	this->memType = memType;
	mem = *memArr;
	for (unsigned int i = 0; i < mem.size(); i++) {
		mem[i]->setMemory(this);
	}
}

memory::~memory() {
	for (int i = 0; i < mem.size(); i++) {
		memObject* mObj = mem[i];
		if (mObj != NULL) {
			delete mObj;
		}
	}
}

void memory::add(memObject* mObj, unsigned int position) throw(pramException) {
	if (position < 0 || position >= mem.size() || mem[position] == NULL) {
		throw memoryException("Unallocated memory");
	}
	mem[position]->set(mObj);
}

memObject* memory::get(unsigned int position) throw(memoryException) {
	if (position >= mem.size() || position < 0) {
		throw memoryException("Memory index out of bounds!");
	}
	if (mem[position] == NULL) {
		throw memoryException("Unallocated memory");
	}
	return mem[position]->get();
}

void memory::resolveMemAccess() {
	std::set<memObject *>::iterator it = writtenObjects.begin();
	for (; it != writtenObjects.end(); it++) {
		(*it)->resolveMem();
	}
	readObjects.clear();
	writtenObjects.clear();
}

void memory::addRead(memObject* mObj) throw(memAccessException) {
	if (memType != mt_erew) {
		return;
	}
	if (readObjects.count(mObj) > 0) {
		throw memAccessException("Concurrent read! Variable: " + mObj->getName());
	}
	readObjects.insert(mObj);
}

/**
 * Tato metoda sluzi na odhalenie paralelnych zapisov, keby sa nemalo (modely EW).
 */
void memory::addWrite(memObject* mObj, memObject* value) throw(memAccessException) {
	switch (memType) {
	case mt_erew:
	case mt_crew: {
		if (writtenObjects.count(mObj) > 0) {
			throw memAccessException("Concurrent write! Variable: " + mObj->getName());
		}
		break;
	}
	case mt_crcw_comm:
	case mt_crcw_arb: {
		// tieto cases sa riesa v memObject.resolveMem na konci kola
		break;
	}
	case mt_local: {
		return;
	}
	}
	writtenObjects.insert(mObj);
}

void memory::setMemType(MemType mType) {
	memType = mType;
}

MemType memory::getMemType() {
	return memType;
}
