#ifndef MEMORY_H_
#define MEMORY_H_

enum MemType {mt_erew, mt_crew, mt_crcw_comm, mt_crcw_arb, mt_local};

#include "memObject.h"
#include "Exceptions.h"

#include <vector>
#include <exception>
#include <set>

class memObject;

/**
** Trieda na pracu s pamatou. Z vonku sa pouzivaju hlavne metody get a set. Zakladnou jednotkou je
** trieda memObject.
*/
class memory {
protected:
	std::vector<memObject *> mem;
	std::set<memObject *> readObjects;
	std::set<memObject *> writtenObjects;
	MemType memType;
public:
	memory(std::vector<memObject *>* memArr, MemType memType = mt_local);
	virtual ~memory();
	void add(memObject* mObj, unsigned int position) throw(pramException);
	memObject* get(unsigned int position) throw(memoryException);
	void resolveMemAccess();
	void addRead(memObject* mObj) throw(memAccessException);
	void addWrite(memObject* mObj, memObject* value) throw(memAccessException);
	void setMemType(MemType mType);
	MemType getMemType();
};

#endif /* MEMORY_H_ */
