#ifndef SYMBOLTABLE_H
#define SYMBOLTABLE_H

#include <map>
#include <vector>
#include <string>

enum VarType {v_int, v_arr};

#include "memory.h"
#include "memInteger.h"
#include "memArray.h"
#include "Exceptions.h"

class SymbolTable {
private:
	std::map<int,int> table;
	std::map<std::string, std::pair<int, VarType> > names;
	int next;
public:
	SymbolTable();
	int getValue(int index) throw(symbolTableException);
	int getIndex(std::string name) throw(symbolTableException);
	int addName(std::string name, VarType type);
	int addNameWithValue(std::string name, int value, VarType type) throw(symbolTableException);
	memory* getMemory();
};

#endif
