#include "SyncObj.h"

SyncObj::SyncObj(SyncObj* parent): parent(parent) {
	childTrue = NULL;
	childFalse = NULL;
}

SyncObj::~SyncObj() {
}

void SyncObj::addProcess(Process* process) {
	processes.insert(process);
	process->setSyncObj(this);
}

void SyncObj::removeProcess(Process* process) {
	processes.erase(process);
	process->setSyncObj(NULL);
}

void SyncObj::remove() {
	if (parent != NULL) {
		parent->removeChild(this);
	}
}

bool SyncObj::canWakeUp() {
	return childTrue == NULL && childFalse == NULL;
	/*if (childTrue == NULL && childFalse == NULL) {
		std::set<Process *>::iterator it;
		for (it = processes.begin(); it != processes.end(); it++) {

		}
	}*/
}

void SyncObj::removeChild(SyncObj* child) {
	if (childTrue == child) {
		childTrue = NULL;
		return;
	}
	if (childFalse== child) {
		childFalse = NULL;
		return;
	}
}

SyncObj* SyncObj::trueChild() {
	if (childTrue == NULL) {
		childTrue = new SyncObj(this);
	}
	return childTrue;
}

SyncObj* SyncObj::falseChild() {
	if (childFalse == NULL) {
		childFalse = new SyncObj(this);
	}
	return childFalse;
}

bool SyncObj::empty() {
	return processes.size() == 0;
}

SyncObj* SyncObj::getParent() {
	return parent;
}

std::set<Process *>& SyncObj::getProcesses() {
	return processes;
}
